`%id*%` <- function(A,b) {
  if (.is_identity(A)) return(b)
  return(A %*% b)
}

`%*id%` <- function(a,B) {
  if (.is_identity(B)) return(a)
  return(a %*% B)
}


`%id*id%` <- function(A,B) {
  if (.is_identity(A)) return(B)
  if (.is_identity(B)) return(A)
  return(A %*% B)
}

.calcZWZt_mat_or_diag <- function(Z,W,returnMat) { ## fixefVar or fixefVar + a bit of ranefVar
  if (returnMat) {
    return(Z[] %id*id% W[] %id*id% t(Z)[]) ## not ZWZT functions bc W not diag a priori if (returnMat)
  } else { ## returns only the diagonal
    if (is.vector(W)) {
      return(rowSums(.Matrix_times_Dvec(Z[],W[]) * Z[]))
    } else {
      rownames(W) <- colnames(W) <- NULL ## inhibits a useless warning from Matrix:: dimNamesCheck 
      premul <- Z[] %id*id% W[]
      return(rowSums(suppressMessages(premul * Z[]))) ## suppress message("method with signature...") [found by debug(message)]
    }
  }
}


.calc_locnewZAC <- function(newnrand,locnewZA,locColdnewList) {
  if (newnrand>1L) {
    locnewZAClist <- list()
    for (rd in seq_len(newnrand)) {
      terme <- locnewZA[[rd]] %id*id% t(locColdnewList[[rd]])[]
      locnewZAClist[[rd]] <- as.matrix(terme)
    }
    newZAC <- do.call(cbind,locnewZAClist)
  } else {
    terme <- locnewZA[[1L]] %id*id% t(locColdnewList[[1L]])[] 
    newZAC <- as.matrix(terme) ## loses names but they are not useful here 
  }
  return(newZAC)
}

.calc_sliceVar <- function(it, slices, ColdnewList,X.pv,newZAlist,beta_w_cov,
                           CnewnewList,
                           invColdoldList, ## may be null is no newdata.
                           lambda, ## may be null if no newdata.
                           logdispObject, ## should remain NULL is disp not requested
                           newinold, 
                           covMatrix,blockSize) {
  slice <- (slices[it]+1L):slices[it+1L]
  ## here  the problem is that newZA should map the new response levels 
  ## to the 'new' levels of random effects  
  newnrand <- length(newZAlist) ## or of any other of the lists of matrices
  templateList <- vector("list", length = newnrand)
  requiredLevelsList <- templateList
  for (rd in seq_len(newnrand)) requiredLevelsList[[rd]] <- which(colSums(newZAlist[[rd]][slice,,drop=FALSE])>0L) 
  locnewZA <- templateList
  for (rd in seq_len(newnrand)) locnewZA[[rd]] <- newZAlist[[rd]][slice,requiredLevelsList[[rd]],drop=FALSE] 
  # predVar in observed points uses C rather than L hence we need to compute ZA.C in all cases ('newZAC")
  # and then we need newZA and ColdnewList; the only argument that is needed only for newdata would be locCnewnewList
  locColdnewList <- templateList
  for (rd in seq_len(newnrand)) locColdnewList[[rd]] <- structure(
    ColdnewList[[rd]][,requiredLevelsList[[rd]],drop=FALSE],
    isEachNewLevelInOld = attr(ColdnewList[[rd]],"isEachNewLevelInOld")[requiredLevelsList[[rd]]] ## for non-spatial effects; (qualifies sub cols of sub Cnewold)
  )
  if ( ! is.null(CnewnewList)) { ## if newdata...
    locCnewnewList <- templateList
    for (rd in seq_len(newnrand)) locCnewnewList[[rd]] <- CnewnewList[[rd]][requiredLevelsList[[rd]],requiredLevelsList[[rd]],drop=FALSE] 
  } else locCnewnewList <- NULL
  .calcPredVar(ColdnewList=locColdnewList, ## needed only if newdata in predict() call
               X.pv=X.pv[slice,,drop=FALSE],## problem is that this creates the apparence of new data end more calculations
               newZAC= .calc_locnewZAC(newnrand,locnewZA,locColdnewList),
               newZAlist=locnewZA, ## either newZA or newZAC needed even if no newdata in predict() call
               beta_w_cov=beta_w_cov,CnewnewList=locCnewnewList,
               invColdoldList=invColdoldList, ## needed only if newdata in predict() call
               lambda=lambda,
               logdispObject=logdispObject,
               newinold=newinold,
               covMatrix=covMatrix,blockSize=blockSize)
}

.calc_Evarlist <- function(it, ColdnewList, lambda, CnewnewList, invColdoldList, newZAlist, covMatrix) {
  isEachNewLevelInOld <- attr(ColdnewList[[it]],"isEachNewLevelInOld")
  if ( ! is.null(isEachNewLevelInOld)) { ## non spatial effect: a vector of booleans indicating whether new is in old (qualifies cols of Cnewold)
    Evar <- Diagonal(x=lambda[it]*as.numeric(! isEachNewLevelInOld))
  } else { ## spatial effect
    if (is.null(CnewnewList[[it]])) { ## we compute only the var vector
      Cno_InvCoo_Con <- colSums(ColdnewList[[it]] * ( (invColdoldList[[it]])[] %id*id% (ColdnewList[[it]])[] ) )
      Evar <- lambda[it] * (1 - Cno_InvCoo_Con)
    } else { ## full cov matrix
      Cno_InvCoo_Con <- t(ColdnewList[[it]])[] %id*id% (invColdoldList[[it]])[] %id*id% (ColdnewList[[it]])[]
      Evar <- lambda[it] * (CnewnewList[[it]] - Cno_InvCoo_Con)
    }
  } 
  terme <- .calcZWZt_mat_or_diag(newZAlist[[it]],Evar,covMatrix)
  if (covMatrix) {
    return(as.matrix(terme))  ## loses names but they are not useful here
  } else return(terme)
}

.calcPredVar <- function(ColdnewList,X.pv,newZAC=NULL,newZAlist,beta_w_cov,
                        CnewnewList=NULL,
                        invColdoldList=NULL, ## may be null is no newdata.
                        lambda=NULL, ## may be null if no newdata.
                        logdispObject=NULL, ## should remain NULL is disp not requested
                        newinold, 
                        covMatrix=FALSE,blockSize=100L) {
  nrX <-  nrow(X.pv)
  if ( ( ! covMatrix ) && nrX > blockSize) {
    ### this part of code is tested by the test-predVar code on Loaloa data
    # et par test geostat dans probitgem (iterateSEMSmooth -> .sampleNextPars -> .spaMM_rhullByEI)
    slices <- unique(c(seq(0L,nrX,blockSize),nrX))
    predVar <- unlist(lapply(seq_len(length(slices)-1L), .calc_sliceVar,
                             slices=slices,
                             ColdnewList=ColdnewList,X.pv=X.pv,
                             # newZAC computed by .calc_sliceVar for inner call of .calcPredVar
                             newZAlist=newZAlist,beta_w_cov=beta_w_cov,
                             CnewnewList=CnewnewList,
                             invColdoldList=invColdoldList, ## may be null is no newdata.
                             lambda=lambda, ## may be null if no newdata.
                             logdispObject=logdispObject, ## should remain NULL is disp not requested
                             newinold=newinold, 
                             covMatrix=covMatrix,blockSize=blockSize)) ## -> recursive call to .calcPredVar 
    return(predVar)
  }
  ############################################################
  if (is.null(newZAC)) {
    newnrand <- length(newZAlist) ## or of any other of the lists of matrices
    newZAC <- .calc_locnewZAC(newnrand,newZAlist,ColdnewList)
  }
  newAugX <- cbind2(X.pv,newZAC) ## mais en fait pas un AugX since it uses C (in C.w) rather than L (in L.v)
  ## First component of predVar
  # variance of expectation of Xbeta+Zb due to var of (hat(beta),hat(v)) using E[b] as function of hat(v)
  predVar <- .calcZWZt_mat_or_diag(newAugX,beta_w_cov,covMatrix)
  #### next line of code is an imperfect but useful patch
  # possible problems:
  # * (unhandled) Evar can also be (numerically) negative
  # * (quick-patched) same for min_eigen 
  if ( is.null(dim(predVar))) {
    predVar <- pmax(apply(newAugX^2,1L,sum)*max(0,attr(beta_w_cov,"min_eigen")), predVar)
  } else predVar <- pmax(.tcrossprod(newAugX)*max(0,attr(beta_w_cov,"min_eigen")), predVar)
  ## Second component of predVar:
  # Evar: expect over distrib of (hat(beta),hat(v)) of [variance of Xbeta+Zb given (hat(beta),hat(v))]
  if ( ! is.null(invColdoldList)) { ## must be equivalent to the presence of newdata
    newnrand <- length(newZAlist) ## or of any other of the lists of matrices
    Evarlist <- lapply(seq_len(newnrand), .calc_Evarlist,  
                       ColdnewList=ColdnewList, lambda=lambda, CnewnewList=CnewnewList, 
                       invColdoldList=invColdoldList, newZAlist=newZAlist, covMatrix=covMatrix)
    if (newnrand>1L) {Evar <- Reduce("+",Evarlist)} else {Evar <- Evarlist[[1]]}
    predVar <- predVar + Evar
  }
  # If components for uncertainty in dispersion params were requested,
  #   logdispObject is not NULL
  # If some components ere computable, $$dwdlogdisp should not be NULL
  # Former approach (changed 08/2016) was to test logdispObject and then 
  #   for any 'problem'. But there may some 'problem' and still a valid logdispObject
  # => In new version, dwdlogdisp should be either NULL or a conforming matrix;
  #  'problems" should not be tested.
  if ( ! is.null(dwdlogdisp <- logdispObject$dwdlogdisp) ) {
    logdisp_cov <- logdispObject$logdisp_cov
    col_info <- attr(dwdlogdisp,"col_info") ## ranefs for which there is a col in dwdlogdisp
    if ( length(newinold) != col_info$nrand) { ## selection of blocks for re.form ranefs # fixme: this code is not (testthat-)checked
      cum_n_u_h <- col_info$cum_n_u_h
      which_ranef_cols <- intersect(col_info$ranef_ids,newinold)
      u_range <- vector("list",length = length(which_ranef_cols))
      for (it in which_ranef_cols) u_range[[it]] <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
      u_range <- unlist(u_range)
      whichcols <- c(which_ranef_cols,col_info$phi_cols)
      dwdlogdisp <- dwdlogdisp[u_range,whichcols]
      logdisp_cov <- logdisp_cov[whichcols,whichcols]
    }
    newZACw <- newZAC %*% dwdlogdisp ## typically (nnew * n_u_h) %*% (n_u_h * 2) = nnew * 2 hence small 
    if (covMatrix) {
      disp_effect_on_newZACw <- newZACw %*% logdisp_cov %*% t(newZACw)  
    } else {
      premul <- newZACw %*% logdisp_cov
      disp_effect_on_newZACw <- rowSums(premul * newZACw)
    }
    predVar <- predVar + disp_effect_on_newZACw
  }
  return(predVar) ## may be a Matrix
}


.calcResidVar <- function(object,newdata=NULL) {
  phi.object <- object$phi.object
  if (is.null(phi_outer <- phi.object$phi_outer)) { ## valid whether newdata are NULL or not:
    glm_phi <- phi.object[["glm_phi"]]
    if (is.null(glm_phi)) glm_phi <- .get_glm_phi(object)
    residVar <- predict(glm_phi, newdata=newdata, type="response")
  } else { ## phi, but not glm_phi
    if (length(phi_outer)==1L) {
      if (is.null(newdata)) {
        residVar <- rep(phi_outer,nrow(object$X.pv)) ## assumes (length(phi_outer)==1L)           
      } else residVar <- rep(phi_outer,nrow(newdata))
    } else stop("Unable to compute 'residVar' given length(phi_outer)!=1L.") ## and no glm_phi
    ## FR->FR we could improve this if we get a glm_phi when phi was estimed by outer iterations
  }
  residVar
}  

.calcNewCorrs <- function(object,locdata,which,
                         corr.model) {
  resu <- list(uuCnewold=NULL,uuCnewnew=NULL)
  if (any(unlist(which))) {
    # (1) code  common to different ranef models 
    olduniqueGeo <- attr(object,"info.uniqueGeo")
    geonames <- colnames(olduniqueGeo)
    newuniqueGeo <- .calcUniqueGeo(data=locdata[,geonames,drop=FALSE]) ## It is essential that it keeps the same order as .spMMfactorlist -> ULI -> unique. 
    ## distance matrix and then call to correl fn:
    if (corr.model=="AR1") {
      if (which$no) resu$uuCnewold <- proxy::dist(newuniqueGeo,olduniqueGeo) 
      if (which$nn) resu$uuCnewnew <- proxy::dist(newuniqueGeo)
    } else {
      ### rho only used to compute scaled distances
      rho <- .getPar(object$ranFix,"rho")
      if ( ! is.null(rho_mapping <- attr(object,"dist_info")$rho.mapping)
           && length(rho)>1L ) rho <- .calc_fullrho(rho=rho,coordinates=geonames,rho_mapping=rho_mapping)
      ## rows from newuniqueGeo, cols from olduniqueGeo:
      msd.arglist <- list(uniqueGeo=newuniqueGeo,uniqueGeo2=olduniqueGeo,
                          rho=rho,return_matrix=TRUE)
      if ( ! is.null(dist.method <- object$control.dist$dist.method)) msd.arglist$dist.method <- dist.method
      if (which$no) resu$uuCnewold <- do.call(make_scaled_dist,msd.arglist) ## ultimately allows products with Matrix ## '*cross*dist' has few methods, not even as.matrix
      if (which$nn)  {
        msd.arglist$uniqueGeo2 <- NULL
        if (nrow(msd.arglist$uniqueGeo)==1L) {
          resu$uuCnewnew <- matrix(0)
        } else resu$uuCnewnew <- do.call(make_scaled_dist,msd.arglist) 
      }
    }
    # (2) code specific to each ranef model
    if ( corr.model!="") {
      resu <- .calc_corr_from_dist(resu, object, corr.model, which)
    }
  }
  return(resu)
}


.process_variances <- function(variances) {
  if (identical(variances$BH98,TRUE)) { ## my interpretation of BH98
    variances$predVar <- TRUE ## implies $linPred <- TRUE by default
    #variances$respVar <- FALSE ## default
    variances$disp <- FALSE ## non-default
    variances$cov <- TRUE ## non-default
  } else variances$BH98 <- FALSE
  # $respVar implies components
  if (is.null(variances$predVar)) variances$predVar <- variances$respVar ## may still be NULL
  if (is.null(variances$residVar)) variances$residVar <- variances$respVar ## may still be NULL
  if (is.null(variances$respVar)) variances$respVar <- FALSE 
  # $predVar implies components
  if (is.null(variances$linPred)) variances$linPred <- variances$predVar ## may still be NULL
  if (is.null(variances$disp)) variances$disp <- variances$predVar ## may still be NULL
  if (is.null(variances$predVar)) variances$predVar <- FALSE 
  # Do not let any component empty
  if (is.null(variances$fixefVar)) variances$fixefVar <- FALSE 
  if (is.null(variances$linPred)) variances$linPred <- FALSE 
  if (is.null(variances$disp)) variances$disp <- FALSE ## uncertaintly on dispersion parameters
  if (is.null(variances$residVar)) variances$residVar <- FALSE ## uncertaintly on dispersion parameters
  if (is.null(variances$cov)) variances$cov <- FALSE
  ##
  return(variances)
}

.match_old_new_levels <- function(it, old_cum_n_u_h, newinold, spatialOne, w_h_coeffs, subZAlist, newZAClist, lcrandfamfam, object) {
  oldu.range <- (old_cum_n_u_h[newinold[it]]+1L):(old_cum_n_u_h[newinold[it]+1L])
  if (it %in%  spatialOne) {     # %in% handles zero-length spatialOne...
    return(w_h_coeffs[oldu.range])          
  } else {
    oldlevels <- colnames(subZAlist[[it]])
    newlevels <- colnames(newZAClist[[it]])
    interlevels <- intersect(oldlevels,newlevels)
    oldpos <- which(oldlevels %in% interlevels) ## positions: handle replicates for random-coef
    newpos <- which(newlevels %in% interlevels)
    oldv <- w_h_coeffs[oldu.range]
    names(oldv) <- oldlevels
    psi_M <- switch(lcrandfamfam[it], 
                    gaussian = 0,
                    gamma = 1, 
                    beta = 1/2, 
                    "inverse.gamma" = 1
    )
    vpsi_M <- object$rand.families[[newinold[it]]]$linkfun(psi_M) 
    ## since vpsi_M can be non-zero, the expectation of the response can be modified in a re.form model compared to the original
    newv <- rep(vpsi_M,length(newlevels)) ## fills new levels with psi_M
    names(newv) <- newlevels
    newv[newpos] <- oldv[oldpos] 
    return(newv)
  }
}



## (1) for surface prediction: (developed in InferentialSimulation/InferentialSimulation.R)
## (2) But also for generation of fixed effects in simulation of nested-effects models
predict.HLfit <- function(object, newdata = newX, newX = NULL, re.form = NULL,
                          variances=list(),
                          binding = FALSE, 
                          intervals = NULL,
                          level = 0.95,
                          ...) { ## but not new Y
  if ( ! is.null(variances$ranef)) {
    message("'variances$ranef' is obsolete: I interpret this as 'variances$linPred'.")
    variances$linPred <- variances$ranef
    variances$ranef <- NULL
  }
  if ( ! is.null(variances$sum)) {
    message("'variances$sum' is obsolete: I interpret this as 'variances$respVar'.")
    variances$respVar <- variances$sum
    variances$sum <- NULL
  }
  if (is.null(object$envir)) object$envir <- list2env(list(), ## back-compatibility fix for old objects
                                                     parent=environment(HLfit_body))
  ## the final components returned as attributes have names ...Var, other terms should be named differently
  checkIntervals <- (substr(x=intervals, nchar(intervals)-2, nchar(intervals))=="Var")
  if (any(!checkIntervals)) warning("Element(s)",intervals[!checkIntervals],"are suspect, not ending in 'Var'.")
  # possible elements in return value: fixefVar, predVar, residVar, respVar
  variances[intervals] <- TRUE 
  variances <- .process_variances(variances)
  new_X_ZACblob <- .calc_new_X_ZAC(object=object, newdata=newdata, re.form = re.form,
                 variances=variances, needNewNew=variances$cov)
  locdata <- new_X_ZACblob$locdata
  newX.pv <- new_X_ZACblob$newX.pv
  newZAlist <- new_X_ZACblob$newZAlist
  newnrand <- length(newZAlist) ## may be reduced if non trivial re.form
  newZAClist <- new_X_ZACblob$newZAClist
  if (newnrand>1L) {
    newZAC <- do.call(cbind,newZAClist)
  } else {newZAC <- newZAClist[[1]]}
  uuCnewold <- new_X_ZACblob$uuCnewold
  uuCnewnew <- new_X_ZACblob$uuCnewnew
  oldnewClist <- new_X_ZACblob$oldnewClist  # cf calcNewCorrs
  subZAlist <- new_X_ZACblob$subZAlist
  spatialOne <- new_X_ZACblob$spatialOne
  spatial.model <- new_X_ZACblob$spatial.model
  newinold <- new_X_ZACblob$newinold ## says which ranef is kept by re.form
  eta <- new_X_ZACblob$etaFix ## may be NULL. otherwise only fixed part so far: cf addition of ZACw below
    #
  ## (1) computes fv (2) compute predVar
  ##### fv
  if (.noRanef(re.form)) {
    fv <- object$family$linkinv(eta) 
  } else if ( is.null(newdata) && ! inherits(re.form,"formula")) {
    fv <- object$fv ## same length including replicates
    if (variances$predVar) {
      eta <- object$family$linkfun(fv) 
      newZAlist <- subZAlist ## useful if predVar
    }
  } else { ## 
    if ( newnrand==0L ) {
      newZAlist <- NULL
    } else {
      ## for random-slope model the original eta's can be recomputed as 
      # object$X.pv %*% fixef(object) + 
      #    object$ZAlist[[1]] %*% object$strucList[[1]] %*% object$v_h
      #
      #### precomputation of coeffs
      ## on the gaussian scale, L.v_ori ~ lam C (lam C + phi I)^{-1}y 
      ## new random autocorr term ~ lam c (lam C + phi I)^{-1}y = c C^{-1} L_ori.v_ori = c [t(L_ori)]^{-1} v_ori
      ## [t(L_ori)]^{-1} v_ori can be computed once for all predictions => 'w_h_coeffs'
      if (is.null(w_h_coeffs <- object$envir$w_h_coeffs)) { 
        object$envir$w_h_coeffs <- w_h_coeffs <- .calc_invL_coeffs(object,object$v_h)
      }
      old_cum_n_u_h <- attr(object$lambda,"cum_n_u_h")
      lcrandfamfam <- attr(object$`rand.families`,"lcrandfamfam")[newinold]
      augm_w_h_coeffs <- lapply(seq_len(newnrand),.match_old_new_levels,
                                old_cum_n_u_h=old_cum_n_u_h, newinold=newinold, spatialOne=spatialOne, w_h_coeffs=w_h_coeffs, 
                                subZAlist=subZAlist, newZAClist=newZAClist, lcrandfamfam=lcrandfamfam, object=object)
      if (newnrand>1L) {
        ZACw <- vector("list", length=newnrand )
        for (it in seq_len(newnrand)) ZACw[[it]] <- drop(newZAClist[[it]][] %*% augm_w_h_coeffs[[it]])
        ZACw <- do.call(cbind,ZACw)
        ZACw <- rowSums(ZACw)
      } else ZACw <- drop(newZAClist[[1]][] %*% augm_w_h_coeffs[[1]])
      eta <- eta + ZACw ## (length(eta)) col vector from coeffs = length(eta) row vector...
    }
    # done with eta
    if (variances$BH98) {
      fv <- eta
    } else fv <- object$family$linkinv(eta) ## ! freqs for binomial, counts for poisson
  }
  resu <- as.matrix(fv) ## suitable for objective function of optim() etc ## matrix ! maybe more suitable than data frame as objective function
  #rownames(resu) <- make.names(rownames(resu),unique = TRUE)
  if ( ! is.logical(binding) ) { ## expecting a string
    binding <- .makenewname(base=binding,varnames=colnames(locdata)) ## 09/11/2014 = posterior to CRAN 1.4.1
    resu <- data.frame(resu)
    colnames(resu) <- binding
    resu <- cbind(locdata,resu) ## becomes a data frame !
    attr(resu,"fittedName") <- binding
  } else { ## expecting binding= FALSE
    if (ncol(locdata)>0)  attr(resu,"frame") <- locdata 
  }
  ##### (2) predVar
  if(variances$predVar && identical(attr(object$ZAlist, "anyRandomSlope"),TRUE)) {
    warning("This prediction variance computation is not yet implemented for random-coefficient models")
  }
  if(variances$linPred) {
    beta_cov <- .get_beta_cov_any_version(object)
    beta_w_cov <- .get_beta_w_cov(object)
    if (inherits(re.form,"formula")) {
      # identifies an selects columns for the [retained ranefs, which are given by newinold 
      subrange <- vector("list",length = length(newinold))
      for (it in newinold) subrange[[it]] <- (old_cum_n_u_h[it]+1L):(old_cum_n_u_h[it+1L])
      subrange <- unlist(subrange)
      Xncol <- ncol(beta_cov)
      subrange <- c(seq_len(Xncol),subrange + Xncol)
      beta_w_cov <- beta_w_cov[subrange,subrange]
    }
    if ( ! is.null(newdata)) {
      invColdoldList <- .get_invColdoldList(object)
      ## list for Cnewnew, which enters in  newZA %*% Cnewnew %*% tnewZA, hence should not represent newZA itself 
      if (newnrand>0L) {
        newnewClist <- vector("list", length=newnrand ) 
        for (it in seq_len(newnrand)) if ( it %in% spatialOne) { ## avoids running the next algo which is slow on large matrices
          newnewClist[[it]] <- uuCnewnew ## already computed for point prediction
        } else { 
          newnewClist[[it]] <- Diagonal(ncol(newZAlist[[it]])) ## diag(ncol(newZAlist[[it]]))
        }
      } 
    } else {
      invColdoldList <- NULL
      newnewClist <- NULL
    }
    if (newnrand>0L) {
      if (variances$BH98) newX.pv[] <- 0
      loclist <- list(X.pv=newX.pv,beta_w_cov=beta_w_cov,covMatrix=variances$cov,lambda=object$lambda,
                      newinold=new_X_ZACblob$newinold)
      if (!is.null(uuCnewnew)) {
        uuCnewnewList <- vector("list", length=newnrand ) 
        for (it in seq_len(newnrand)) if (it %in% spatialOne) { ## avoids running the next algo which is slow on large matrices
          uuCnewnewList[[it]] <- (uuCnewnew)
        } else uuCnewnewList[[it]] <- (NULL)
        loclist$CnewnewList <- uuCnewnewList 
      } ## else no loclist$CnewnewList (tested in calcPredVar) 
      #
      if ( ! is.null(newdata)) loclist$invColdoldList <- invColdoldList
      loclist$ColdnewList <- oldnewClist
      loclist$newZAlist <- newZAlist
      if (variances$disp) loclist$logdispObject <- .get_logdispObject(object)
      if (variances$cov) {
        respVar <- as.matrix(do.call(.calcPredVar,loclist)) ## matrix, not Matrix (assumed below)
        rownames(respVar) <- colnames(respVar) <- rownames(locdata)
      } else {
        respVar <- do.call(.calcPredVar,loclist) 
        names(respVar) <- rownames(locdata)
      }
    } else {
      if (variances$cov) {
        respVar <- matrix(0,nrow=nrow(locdata),ncol=nrow(locdata))
      } else respVar <- rep(0,nrow(locdata))
    }
  } else if (any(unlist(variances))) {
    respVar <- rep(0,nrow(locdata))
  } else respVar <- NULL 
  beta_cov <- .get_beta_cov_any_version(object)
  if (! is.null(beta_cov)) {
    if ( variances$fixefVar || (newnrand==0L && variances$linPred) ) {
      fixefcov <- newX.pv %*% beta_cov %*% t(newX.pv)
      if (variances$cov) {
        attr(resu,"fixefVar") <- fixefcov 
      } else attr(resu,"fixefVar") <- diag(fixefcov)
      if (newnrand==0L) { ## otherwise there is already such a term in predVar
        respVar <- respVar + attr(resu,"fixefVar") 
      }
    }
  }
  attr(resu,"predVar") <- respVar ## vector or matrix
  if ( ! is.null(respVar) && object$family$link!="identity") {
    dmudeta <- object$family$mu.eta(eta)
    if (!is.null(dim(respVar))) {
      respVar <- sweep(respVar, MARGIN = 1, dmudeta, `*`) ## premul
      respVar <- sweep(respVar, MARGIN = 2, dmudeta, `*`) ## postmul
    } else respVar <- respVar*(dmudeta^2)
  }
  if (variances$residVar) {
    pw <- object$prior.weights
    if ( ! (attr(pw,"unique") && pw[1L]==1L)) {
      if (! identical(spaMM.getOption("prior_weights_residvar_warned"),TRUE)) {
        warning("Prior weights are not taken in account in residVar computation.")
        spaMM.options(prior_weights_residvar_warned=TRUE)
      }
    }
    if (object$family$family %in% c("poisson","binomial","COMPoisson","negbin")) {
      attr(resu,"residVar") <- object$family$variance(fv)
    } else attr(resu,"residVar") <- .calcResidVar(object,newdata=locdata) 
    if (inherits(respVar,"matrix")) {
      nc <- ncol(respVar)
      diagPos <- seq.int(1L,nc^2,nc+1L)
      respVar[diagPos] <- respVar[diagPos] + attr(resu,"residVar")
    } else respVar <- respVar + attr(resu,"residVar")
  }
  if (variances$respVar) attr(resu,"respVar") <- respVar
  if ( is.matrix(resu) && NCOL(resu)==1L) {
    class(resu) <- c("predictions",class(resu))
  } ## for print.predictions method which expects a 1-col matrix
  # intervals
  checkVar <- setdiff(intervals,names(attributes(resu)))
  if (length(checkVar)>0L) {
    warning(paste("Variances",paste(checkVar,collapse=", "),
                  "not available for interval computation.\n Check arguments."))
    intervals <- intersect(intervals,names(attributes(resu)))
  } 
  if(length(intervals)>0L) {
    intervalresu <- NULL
    for (st in intervals) {
      varcomp <- attr(resu,st)
      if (is.null(varcomp)) warning(paste("Prediction variance component",st,"requested but not available: check input."))
      if (is.matrix(varcomp)) varcomp <- diag(varcomp)
      eta <- object$family$linkfun(resu[,1L])
      pv <- 1-(1-level)/2
      ## special case for simple LM
      if (length(object$rand.families)==0L && # not mixed
          object$family$family=="gaussian" &&
          deparse(object$resid.predictor)=="~1" # not heteroscedastic
          ) { 
        nobs <- length(object$y)
        resdf <- nobs - ncol(object$X.pv) ## don't use fixef here, that contains bot NAs and argument etaFix$beta! 
        is_REML <- ( .REMLmess(object,return_message=FALSE))
        if ( ! is_REML) {
          vart <- varcomp*nobs/resdf
        } else vart <- varcomp
        ## FR->FR (use a type attribute for fixef ?)
        sd <- stats::qt(pv,df=resdf)*sqrt(vart)
      } else {
        sd <- qnorm(pv)*sqrt(varcomp)
      }
      interval <- cbind(object$family$linkinv(eta-sd),object$family$linkinv(eta+sd))
      colnames(interval) <- paste(st,c(signif(1-pv,4),signif(pv,4)),sep="_")
      intervalresu <- cbind(intervalresu,interval)
    }
    attr(resu,"intervals") <- intervalresu
  }
  return(resu)
}

print.vcov.HLfit <- function(x, expanded=FALSE, ...) {
  a <- attributes(x)
  attr(x,"beta_v_cov") <- NULL  
  print.default(x)
  cat("with additional attribute(s):")
  std.attr <- c("names","dim","dimnames","class") ## attributes not to be shown
  nam <- names(a)
  if (expanded) { # shows structure of attributes as in utils:::str.default
    cat("\n")
    nest.lev <- 0
    indent.str <- paste(rep.int(" ", max(0, nest.lev + 1)), collapse = "..")
    strO <- getOption("str")
    strO <- utils::modifyList(utils::strOptions(), strO) ## seems to provide a format.fun function
    `%w/o%` <- function(x, y) x[is.na(match(x, y))]
    nfS <- names(fStr <- formals())
    ## this scans the substructure of each attribute
    strSub <- function(obj, ...) {
      nf <- nfS %w/o% c("object", "give.length", "comp.str", 
                        "no.list", names(match.call())[-(1:2)], "...")
      aList <- as.list(fStr)[nf]
      aList[] <- lapply(nf, function(n) eval(as.name(n)))
      strObj <- function(...) utils::str(obj, ...)
      do.call(strObj, c(aList, list(...)), quote = TRUE)
    }
    for (i in seq_along(a)) if (all(nam[i] != std.attr)) {
      cat(indent.str, paste0("- attr(*, \"", nam[i], "\")="), 
          sep = "")
      strSub(a[[i]], give.length = TRUE, indent.str = paste(indent.str, 
                                                            ".."), nest.lev = nest.lev + 1)
    }
  } else {
    cat(" ")
    nam <- setdiff(nam,std.attr)
    cat(paste(nam,collapse=", "))  
    cat("\n")
  }
  invisible() ## do not return x since it has lost a useful attribute
}


`[.predictions` <- function (x, i, j, 
                             drop = TRUE ## by default, this function will return scalar/vector  
                             ) {
  class(x) <- "matrix" ## removes "predictions" => set back later
  #   if (is.data.frame(x)) {
  #     resu <- x[i,j]
  #   } else 
  resu <- x[i,j,drop=drop]
  if ( ! drop) {
    fixefVar <- attr(x, "fixefVar")
    if ( ! is.null(fixefVar)) {
      if (is.null(dim(fixefVar))) {
        fixefVar <- fixefVar[x]
      } else fixefVar <- fixefVar[x,x,drop=FALSE]
    }
    predVar <- attr(x, "predVar")
    if ( ! is.null(predVar)) {
      if (is.null(dim(predVar))) {
        predVar <- predVar[x]
      } else predVar <- predVar[x,x,drop=FALSE]
    }
    frame <- attr(x, "frame")
    if ( ! is.null(frame)) frame <- frame[x,] ## dataframe => nodrop
    residVar <- attr(x, "residVar")
    if ( ! is.null(frame)) residVar <- residVar[x,drop=FALSE]
    respVar <- attr(x, "respVar")
    if ( ! is.null(respVar)) {
      if (is.null(dim(respVar))) {
        respVar <- respVar[x]
      } else respVar <- respVar[x,x,drop=FALSE]
    }
    class(resu) <- c("predictions","matrix")
    structure(resu,fixefVar=fixefVar,predVar=predVar,residVar=residVar,frame=frame,fittedName=attr(x, "fittedName"))
  } else return(resu)
} # Use unlist() to remove attributes from the return value

print.predictions <- function (x, expanded=FALSE, ...) {
  asvec <- as.vector(x) ## important to remove names and keep them separately
  rnames <- rownames(x)
  toolong <- nchar(rnames)>9
  rnames[toolong] <- paste(substr(rnames[toolong],0,8),".",sep="")
  names(asvec) <- rnames
  cat("Point predictions:\n")
  print(asvec)
  cat("*stored as* 1-col matrix with attributes:")
  std.attr <- c("names","dim","dimnames","class") ## attributes not to be shown
  a <- attributes(x)
  nam <- names(a)
  if (expanded) { # shows structure of attributes as in utils:::str.default
    cat("\n")
    nest.lev <- 0
    indent.str <- paste(rep.int(" ", max(0, nest.lev + 1)), collapse = "..")
    strO <- getOption("str")
    strO <- utils::modifyList(utils::strOptions(), strO) ## seems to provide a format.fun function
    `%w/o%` <- function(x, y) x[is.na(match(x, y))]
    nfS <- names(fStr <- formals())
    ## this scans the substructure of each attribute
    strSub <- function(obj, ...) {
      nf <- nfS %w/o% c("object", "give.length", "comp.str", 
                        "no.list", names(match.call())[-(1:2)], "...")
      aList <- as.list(fStr)[nf]
      aList[] <- lapply(nf, function(n) eval(as.name(n)))
      strObj <- function(...) utils::str(obj, ...)
      do.call(strObj, c(aList, list(...)), quote = TRUE)
    }
    for (i in seq_along(a)) if (all(nam[i] != std.attr)) {
      cat(indent.str, paste0("- attr(*, \"", nam[i], "\")="), 
          sep = "")
      strSub(a[[i]], give.length = TRUE, indent.str = paste(indent.str, 
                                                            ".."), nest.lev = nest.lev + 1)
    }
  } else {
    cat(" ")
    nam <- setdiff(nam,std.attr)
    cat(paste(nam,collapse=", "))  
    cat("\n")
  }
  invisible()
}