# 'which' can be any way of indexing a list
getPar <- function(parlist,name,which=NULL) {
  if ( ! is.null(which)) parlist <- parlist[[which]] 
  val <- parlist[[name]] 
  if (is.null(val)) { ## ie name not found a topmost level; scan sublists:
    vallist <- lapply(parlist, function(sublist) {
      if (is.list(sublist)) {sublist[[name]]} else {NULL}
    })
    ll <- sapply(vallist,length)
    ll <- which(ll>0)
    if (length(ll)>1) {
      stop(paste("Found several instances of element '",name,"' in nested list: use 'which' to resolve this.",sep=""))
    } else if (length(ll)==0L) {
      val <- NULL
    } else val <- vallist[[ll]]
  }
  val
}

# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"b") ## 2
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"c") ## 4
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"a") ## error
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"a",which=1) ## 1
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"d") ## NULL


calc_invL <- function(object) {
  LMatrix <- attr(object$predictor,"LMatrix") 
  if ( ! is.null(LMatrix)) {
    cum_n_u_h <- attr(object$lambda,"cum_n_u_h")
    resu <- diag(cum_n_u_h[length(cum_n_u_h)])
    ranefs <- attr(object$ZAlist,"ranefs") 
    if ( ! is.list(LMatrix)) LMatrix <- list(dummyid=LMatrix)
    for (Lit in seq_len(length(LMatrix))) {
      lmatrix <- LMatrix[[Lit]]
      affecteds <- which(ranefs %in% attr(lmatrix,"ranefs"))
      invlmatrix <- solve(lmatrix) ## FR->FR hmf
      for (it in affecteds) {
        u.range <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
        resu[u.range,u.range] <- invlmatrix   
      }  
    }
    return(resu)
  } else return(NULL)
}

## fitted= X.beta + ZLv where we want to be able to write Lv as Cw = L.L'.w 
# => w = inv(L').v
calc_invL_coeffs <- function(object,newcoeffs) {
  LMatrix <- attr(object$predictor,"LMatrix") 
  if ( ! is.null(LMatrix)) {
    cum_n_u_h <- attr(object$lambda,"cum_n_u_h")
    ranefs <- attr(object$ZAlist,"ranefs") 
    if ( ! is.list(LMatrix)) LMatrix <- list(dummyid=LMatrix)
    for (Lit in seq_len(length(LMatrix))) {
      lmatrix <- LMatrix[[Lit]]
      affecteds <- which(ranefs %in% attr(lmatrix,"ranefs"))
      for (it in affecteds) {
        u.range <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
        newcoeffs[u.range] <- solve(t(lmatrix),newcoeffs[u.range])   
      }  
    }
  }
  return(newcoeffs)
}


getHLfit <- function(fitobject) {
  if (inherits(fitobject,"HLfit")) {
    fitobject    
  } else if (inherits(fitobject,"HLCor")) {
    fitobject$hlfit    
  } else if (inherits(fitobject,"corrHLfit")) {
    fitobject$hlfit    
  }
} 

fitted.HLfit <- function(object,...) {
  object <- getHLfit(object)
  object$fv
}

#ranef.HLfit <- function(object,ranef.class=TRUE,...) {
ranef.HLfit <- function(object,...) {
  object <- getHLfit(object)
  lambda.object <- object$lambda.object
  namesTerms <- lambda.object$namesTerms
  repGroupNames <- unlist(lapply(seq_len(length(namesTerms)),function(it) {
    names(namesTerms[[it]]) <- rep(names(namesTerms)[it],length(namesTerms[[it]]))
  })) ## makes group identifiers unique (names of coeffs are unchanged)
  coefficients <- unlist(lambda.object$namesTerms) ## FR->FR store this one for all in lambda.object ?
  ## cf Group and Term columns in output generated by summary.HL()
  res <- object$ranef #random effects \eqn{u}
  attr(res,"nams") <- paste(repGroupNames,coefficients) ## one name for each lambda coefficient. Cf bug detector in print.ranef
  class(res) <- c("ranef",class(res)) ## for print.ranef
  res
}

print.ranef <- function(x,...) {
  cum_n_u_h <- attr(x,"cum_n_u_h")
  nams <- attr(x,"nams")
  if (length(cum_n_u_h) != length(nams)+1L) { ## bug detector (hopefully no bug to be detected)
    message("length(cum_n_u_h) != length(nams)+1L in print.ranef: minor bug, but don't trust the output of print.ranef")
  }
  lapply(seq_len(length(nams)), function(it) {
    #cat(paste(nams[it], " (", cum_n_u_h[it + 1]-cum_n_u_h[it], " levels)\n",sep=""))    
    cat(paste(nams[it], " :\n",sep=""))    
    u.range <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
    print(x[u.range])
  })
  invisible(x)
}

fixef.HLfit <- function(object,...) {
  object <- getHLfit(object)
  object$fixef    
}

logLik.HLfit <- function(object, REML = FALSE, ...) {
  object <- getHLfit(object)
  logL <- object$APHLs$logLapp
  if (is.null(logL)) {
    if (REML) {
      return(object$APHLs$p_bv)
    } else {
      return(object$APHLs$p_v)
    }    
  } else return(logL)
}

vcov.HLfit <- function(object,...) {
  object <- getHLfit(object)
  object$beta_cov
}

# addition post 1.4.4
Corr <- function(object,...) { ## compare ?VarCorr
  if ( ! is.null(LMatrix <- attr(object$predictor,"LMatrix"))) {
    Corr <- tcrossprodCpp(LMatrix)    
  } else {
    message("No 'non-trivial' correlation matrix of random effects")
    Corr <- NA
  }
  return(Corr)
}

dev_resids <- function(object,...) {
  mu <- predict(object)
  weights <- object$weights
  if (is.null(weights)) weights <- 1
  object$family$dev.resids(object$y/weights,mu,weights)
}

deviance.HLfit <- function(object,...) {
  dev_res2 <- dev_resids(object=object,...)
  return(sum(dev_res2))
}  

