% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinar_boot.R
\name{spinar_boot}
\alias{spinar_boot}
\title{(Semi)parametric INAR bootstrap procedure}
\usage{
spinar_boot(
  x,
  p,
  B,
  setting,
  type = NA,
  distr = NA,
  M = 100,
  level = 0.05,
  progress = TRUE
)
}
\arguments{
\item{x}{[\code{integer}]\cr
vector with integer observations.}

\item{p}{[\code{integer(1)}]\cr
order of the INAR model, where \eqn{\code{p} \in \{1,2\}}.}

\item{B}{[\code{integer(1)}]\cr
number of bootstrap repetitions.}

\item{setting}{[\code{string(1)}]\cr
estimation setting \eqn{\in \code{\{"sp", "p"\}}}, where \code{"sp"} defines a semiparametric setting and
\code{"p"} a parametric setting.}

\item{type}{[\code{string(1)}]\cr
type of estimation \eqn{\in \code{\{"mom", "ml"\}}}, where \code{"mom"} performs moment-based estimation and
\code{"ml"} maximum likelihood-based estimation.}

\item{distr}{[\code{string(1)}]\cr
parametric family of innovation distribution \eqn{\in  \code{\{"poi", "geo", "nb"\}}}, where \code{"poi"} denotes
Poi(\code{lambda}), \code{"geo"} Geo(\code{prob}) and \code{"nb"} NB(\code{r}, \code{prob}) distributions.}

\item{M}{[\code{integer(1)}]\cr
upper limit for the innovations.}

\item{level}{[\code{numeric(1)}]\cr
level for the bootstrap confidence intervals (percentile interval and Hall's percentile interval
(bootstrap-t-interval without studentization)).}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default is \code{TRUE}.}
}
\value{
[\code{named list}] with entries
\describe{
\item{\code{x_star}}{[\code{matrix}] of bootstrap observations with
\code{length(x)} rows and \code{B} columns.}
\item{\code{parameters_star}}{[\code{matrix}] of bootstrap estimated
parameters with \code{B} rows.
If \code{setting = "sp"}, each row contains
the estimated coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p} and the
estimated entries of the pmf \eqn{\code{pmf}_0, \code{pmf}_1}, ... where
\eqn{\code{pmf}_i} represents the probability of an innovation being equal
to \eqn{i}.
If \code{setting = "p"}, each row contains the estimated
coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p} and the estimated
parameter(s) of the innovation distribution.}
\item{\code{bs_ci_percentile}}{[\code{named matrix}] with the lower and
upper bounds of Hall's bootstrap percentile confidence intervals for each
parameter in \code{parameters_star}.}
\item{\code{bs_ci_hall}}{[\code{named matrix}] with the lower and
upper bounds of the bootstrap percentile confidence intervals for each
parameter in \code{parameters_star}.}
}
}
\description{
INAR bootstrap procedures for the semiparametric and the parametric INAR setting, where the latter allows for
moment- and maximum likelihood-based estimation and Poisson, geometrically and negative binomially distributed innovations.
}
\examples{
# generate data
dat1 <- spinar_sim(n = 200, p = 1, alpha = 0.5,
                   pmf = c(0.3, 0.3, 0.2, 0.1, 0.1))
dat2 <- spinar_sim(n = 200, p = 2, alpha = c(0.2, 0.3),
                   pmf = dgeom(0:60, 0.5))

\donttest{
# semiparametric INAR(1) bootstrap
spinar_boot(x = dat1, p = 1, B = 50, setting = "sp")
# parametric Geo-INAR(2) bootstrap using moment-based estimation
spinar_boot(x = dat2, p = 2, B = 50, setting = "p", type = "mom", distr = "geo")
}

}
