% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naiveBayes.R
\name{naiveBayes_dynamicPrior}
\alias{naiveBayes_dynamicPrior}
\title{Naive Bayes dynamic prior}
\usage{
naiveBayes_dynamicPrior(
  d,
  nObs = nrow(d),
  mod_train,
  wl,
  class_names,
  nClasses = length(class_names),
  like_names,
  prior_names,
  predictors,
  nPredictors = length(predictors)
)
}
\arguments{
\item{d}{dataframe containing the observations}

\item{nObs}{the number of observations}

\item{mod_train}{the output of naiveBayes_train()}

\item{wl}{window length, points}

\item{class_names}{names of outcome classes}

\item{nClasses}{the number of outcome classes}

\item{like_names}{the names of variables holding likelihoods}

\item{prior_names}{the names of prior variables}

\item{predictors}{the names of predictor variables}

\item{nPredictors}{the number of predicto variables}
}
\description{
Internal soundgen function
}
\details{
A Helper function called by \code{\link{naiveBayes}} to calculate dynamic
priors. Algorithm: average the likelihoods of wl preceding observations
weighted by a Gaussian function, so more recent observations have more
weight.
}
\keyword{internal}
