% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertSpectrogram.R
\name{guessPhase_GL}
\alias{guessPhase_GL}
\title{Guess phase GL}
\usage{
guessPhase_GL(
  spec,
  phase,
  nIter,
  samplingRate,
  overlap,
  wn,
  step_points,
  verbose = TRUE,
  plotError = TRUE
)
}
\arguments{
\item{spec}{the spectrogram that is to be transform to a time series: numeric
matrix with frequency bins in rows and time frames in columns}

\item{phase}{an initial guess at the phase: numeric matrix of the same dimensions as spec}

\item{nIter}{the number of iterations of the GL algorithm (Griffin & Lim,
1984), 0 = don't run}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, blackman, flattop, rectangle}

\item{step_points}{STFT step in points}

\item{verbose}{if TRUE, prints estimated time left every 10\% of GL
iterations}

\item{plotError}{if TRUE, produces a scree plot of squared error over GL
iterations (useful for choosing `nIter`)}
}
\value{
Returns a matrix of the same dimensions as `spec` containing the
  guessed phase.
}
\description{
Internal soundgen function
}
\details{
Uses the iterative method proposed by Griffin & Lim (1984) to guess the phase
of a magnitude spectrogram.
}
\keyword{internal}
