% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phasegram.R
\name{phasegram}
\alias{phasegram}
\title{Phasegram}
\usage{
phasegram(
  x,
  samplingRate = NULL,
  from = NULL,
  to = NULL,
  windowLength = 10,
  step = windowLength/2,
  timeLag = NULL,
  nonlinStats = c("ed", "d2", "ml", "sur"),
  pars_ed = list(max.embedding.dim = 15),
  pars_d2 = list(min.embedding.dim = 2, min.radius = 0.001, n.points.radius = 20),
  pars_ml = list(min.embedding.dim = 2, radius = 0.001),
  pars_sur = list(FUN = nonlinearTseries::timeAsymmetry, K = 1),
  bw = 0.01,
  bins = 5/bw,
  reportEvery = NULL,
  cores = 1,
  rasterize = FALSE,
  plot = TRUE,
  savePlots = NULL,
  colorTheme = c("bw", "seewave", "heat.colors", "...")[1],
  col = NULL,
  xlab = "Time",
  ylab = "",
  main = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{from, to}{if NULL (default), analyzes the whole sound, otherwise
from...to (s)}

\item{windowLength}{the length of each frame analyzed separately (ms)}

\item{step}{time step between consecutive frames (ms)}

\item{timeLag}{time lag between the original and time-shifted version of each
frame that together represent the phase portrait (ms). Defaults to the
number of steps beyond which the mutual information function reaches its
minimum or, if that fails, the steps until mutual information experiences
the first exponential decay - see \code{\link[nonlinearTseries]{timeLag}}}

\item{nonlinStats}{nonlinear statistics to report: "ed" = the optimal number
of embedding dimensions, "d2" = correlation dimension D2, "ml" = maximum
Lyapunov exponent, "sur" = the results of surrogate data testing for
stochasticity. These are calculated using the functionality of the package
nonlinearTseries, which is seriously slow, so the default is just to get
the phasegram itself}

\item{pars_ed}{a list of control parameters passed to
\code{\link[nonlinearTseries]{estimateEmbeddingDim}}}

\item{pars_d2}{a list of control parameters passed to
\code{\link[nonlinearTseries]{corrDim}}}

\item{pars_ml}{a list of control parameters passed to
\code{\link[nonlinearTseries]{maxLyapunov}}}

\item{pars_sur}{a list of control parameters passed to
\code{\link[nonlinearTseries]{surrogateTest}}}

\item{bw}{standard deviation of the smoothing kernel, as in
\code{\link[stats]{density}}}

\item{bins}{the number of bins along the Y axis after rasterizing (has no
effect if \code{rasterize = FALSE})}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}

\item{rasterize}{if FALSE, only plots and returns Poincare sections on the
original scale (most graphical parameters will then have no effect); if
TRUE, rasterizes the phasegram matrix and plots it with more graphical
parameters}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{colorTheme}{black and white ('bw'), as in seewave package ('seewave'),
or any palette from \code{\link[grDevices]{palette}} such as 'heat.colors',
'cm.colors', etc}

\item{col}{actual colors, eg rev(rainbow(100)) - see ?hcl.colors for colors
in base R (overrides colorTheme)}

\item{xlab, ylab, main}{graphical parameters passed to
soundgen:::filled.contour.mod (if \code{rasterize = TRUE}) or plot (if
\code{rasterize = FALSE})}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters passed to soundgen:::filled.contour.mod
(if \code{rasterize = TRUE})  or plot (if \code{rasterize = FALSE})}
}
\value{
Returns a list of three components: "orig" = the full phasegram;
  "rasterized" = a rasterized version. For both, $time is the middle of each
  frame (ms), $x is the coordinate along a Poincare section (since the audio
  is normalized, the scale is [-1, 1]), and $y is the density of
  intersections of system trajectories with the Poincare section. The third
  component is $descriptives, which gives the result of nonlinear analysis
  per frame. Currently implemented: shannon = Shannon entropy of Poincare
  sections, nPeaks = log-number of peaks in the density distribution of
  Poincare sections, ml = maximum Lyapunov exponent (positive values suggest
  chaos), ed = optimal number of embedding dimensions (shows the complexity
  of the reconstructed attractor), d2 = correlation dimension, sur =
  probability of stochasticity according to surrogate data testing (0 =
  deterministic, 1 = stochastic).
}
\description{
Produces a phasegram of a sound or another time series, which is a collection
of Poincare sections cut through phase portraits of consecutive frames. The x
axis is time, just as in a spectrogram, the y axis is a slice through the
phase portrait, and the color shows the density of trajectories at each point
of the phase portrait.
}
\details{
Algorithm: the input sound is normalized to [-1, 1] and divided into
consecutive frames \code{windowLength} ms long without multiplying by any
windowing function (unlike in STFT). For each frame, a phase portrait is
obtained by time-shifting the frame by \code{timeLag} ms. A Poincare section
is taken through the phase portrait (currently at a fixed angle, namely the
default in \code{\link[nonlinearTseries]{poincareMap}}), giving the
intersection points of trajectories with this bisecting line. The density of
intersections is estimated with a smoothing kernel of bandwidth \code{bw} (as
an alternative to using histogram bins). The density distributions per frame
are stacked together into a phasegram (output: "orig"). The ranges of phase
portraits depend on the amplitude of signal in each frame. The resulting
phasegram can optionally be rasterized to smooth it for plotting (output:
"rasterized").
}
\examples{
target = soundgen(sylLen = 300, pitch = c(350, 420, 420, 410, 340) * 3,
  subDep = c(0, 0, 60, 50, 0, 0) / 2, addSilence = 0, plot = TRUE)
# Nonlinear statistics are also returned (slow - disable by setting
# nonlinStats = NULL if these are not needed)
ph = phasegram(target, 16000, nonlinStats = NULL)

\dontrun{
ph = phasegram(target, 16000, windowLength = 20, step = 20,
  rasterize = TRUE, bw = .01, bins = 150)
ph$descriptives

# Unfortunately, phasegrams are greatly affected by noise. Compare:
target2 = soundgen(sylLen = 300, pitch = c(350, 420, 420, 410, 340) * 3,
  subDep = c(0, 0, 60, 50, 0, 0)/2, noise = -10, addSilence = 0, plot = TRUE)
ph2 = phasegram(target2, 16000)

s2 = soundgen(sylLen = 3000, addSilence = 0, temperature = 1e-6,
  pitch = c(380, 550, 500, 220), subDep = c(0, 0, 40, 0, 0, 0, 0, 0),
  amDep = c(0, 0, 0, 0, 80, 0, 0, 0), amFreq = 80,
  jitterDep = c(0, 0, 0, 0, 0, 3))
spectrogram(s2, 16000, yScale = 'bark')
phasegram(s2, 16000, windowLength = 10, nonlinStats = NULL, bw = .001)
phasegram(s2, 16000, windowLength = 10, nonlinStats = NULL, bw = .02)
}
}
\references{
\itemize{
  \item Herbst, C. T., Herzel, H., Švec, J. G., Wyman, M. T., & Fitch, W.
  T. (2013). Visualization of system dynamics using phasegrams. Journal of
  the Royal Society Interface, 10(85), 20130288.
  \item Huffaker, R., Huffaker, R. G., Bittelli, M., & Rosa, R. (2017). Nonlinear time series analysis with R. Oxford University Press.
}
}
