% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{HzToNotes}
\alias{HzToNotes}
\title{Convert Hz to notes}
\usage{
HzToNotes(h, showCents = FALSE, A4 = 440)
}
\arguments{
\item{h}{vector or matrix of frequencies (Hz)}

\item{showCents}{if TRUE, show cents to the nearest notes (cent = 1/100 of a
semitone)}

\item{A4}{frequency of note A in the fourth octave (modern standard ISO 16 or
concert pitch = 440 Hz)}
}
\description{
Converts from Hz to musical notation like A4 - note A of the fourth octave
above C0 (16.35 Hz).
}
\examples{
HzToNotes(c(440, 293, 115, 16.35, 4))

HzToNotes(c(440, 415, 80, 81), showCents = TRUE)
# 80 Hz is almost exactly midway (+49 cents) between D#2 and E2

# Baroque tuning A415, half a semitone flat relative to concert pitch A440
HzToNotes(c(440, 415, 16.35), A4 = 415)
}
\seealso{
\code{\link{notesToHz}} \code{\link{HzToSemitones}}
}
