% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{identifyAndPlay}
\alias{identifyAndPlay}
\title{Identify and play}
\usage{
identifyAndPlay(
  x,
  y = NULL,
  data = NULL,
  audioFolder,
  to = 5,
  plot = FALSE,
  pch = 19,
  ...
)
}
\arguments{
\item{x, y}{plot coordinates}

\item{data}{dataframe from which x & y are taken, also containing a column
called "file"}

\item{audioFolder}{path to audio files}

\item{to}{play only the first ... s}

\item{plot}{if TRUE, plots the index of clicked points}

\item{pch}{symbol for marking clicked points}

\item{...}{other arguments passed to \code{identify()}}
}
\description{
Internal soundgen function
}
\details{
A wrapper around \code{identify()} intended to play the sound corresponding
to a clicked point.
}
\examples{
\dontrun{
msf = modulationSpectrum('~/Downloads/temp', plot = FALSE)

# Method 1: provide path to folder, leave data = NULL
plot(msf$summary$amFreq_median, msf$summary$amDep_median)
identifyPch(msf$summary$amFreq_median, msf$summary$amDep_median,
  audioFolder = '~/Downloads/temp',
  to = 2,
 plot = TRUE,
 pch = 19)

# Method 2:
plot(msf$summary$amFreq_median, msf$summary$amDep_median)
x = msf$summary$amFreq_median
y = msf$summary$amDep_median
identifyPch(x, y, data = msf$summary,
  audioFolder = '~/Downloads/temp',
  to = 2,
  plot = FALSE,
  pch = 8)
}
}
\keyword{internal}
