% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{playme}
\alias{playme}
\title{Play audio}
\usage{
playme(sound, samplingRate = 16000)
}
\arguments{
\item{sound}{a vector of numbers on any scale or a path to a .wav file}

\item{samplingRate}{sampling rate (only needed if sound is a vector)}
}
\description{
Plays an audio file or a numeric vector. This is a simple wrapper for the
functionality provided by \code{\link[tuneR]{play}}
}
\examples{
# playme('~/myfile.wav')
f0_Hz = 440
sound = sin(2 * pi * f0_Hz * (1:16000) / 16000)
# playme(sound, 16000)
# in case of errors, look into tuneR::play()
}
