% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{costPerPath}
\alias{costPerPath}
\title{Cost per path}
\usage{
costPerPath(path, pitchCands, pitchCert, certWeight, pitchCenterGravity)
}
\arguments{
\item{path}{evaluated path through pitch candidates (as integers specifying
the rows in pitchCands, not the actual values of pitch)}

\item{pitchCands}{a matrix of multiple pitch candidates per fft frame. Each
column is one fft frame, each row is one candidate.}

\item{pitchCert}{a matrix of the same dimensionality as pitchCands specifying
our certainty in pitch candidates}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{pitchCenterGravity}{numeric vector giving the mean of all pitch
candidates per fft frame weighted by our certainty in each of these
candidates}
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for postprocessing of pitch contours called by
\code{\link{pathfinding_slow}}. Calculates the cost of a particular path
through pitch candidates based on pitch jumps and distance from
high-certainty candidates.
}
\keyword{internal}
