% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{summary.soundcorrs}
\alias{summary.soundcorrs}
\title{Generate a segment-to-segment contingency table for two languages.}
\usage{
\method{summary}{soundcorrs}(object, count = "a", unit = "w", ...)
}
\arguments{
\item{object}{[soundcorrs] The dataset from which to draw frequencies. Only datasets with two languages are supported.}

\item{count}{[character] Report either the absolute number of times or words, or relative to how many times or in how many words the given segments correspond to each other. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs. Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}

\item{...}{Unused; only for consistency with \code{\link{print}}.}
}
\value{
[table] The contingency table. The values represent how often the given segments correspond to each other, not how often they co-occur in the same word (cf. \code{\link{coocc}}).
}
\description{
Produce a contingency table detailing all segment-to-segment correspondences in a dataset.
}
\examples{
dataset <- sampleSoundCorrsData.abc
summary (dataset)
round (summary(dataset,count="r"), digits=3)
summary (dataset, unit="o")
}
\seealso{
\code{\link{coocc}}.
}
