% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_list.R
\name{rank_list}
\alias{rank_list}
\title{Create a ranking item list.}
\usage{
rank_list(
  text = "",
  labels,
  input_id,
  css_id = input_id,
  options = sortable_options(),
  orientation = c("vertical", "horizontal"),
  class = "default-sortable"
)
}
\arguments{
\item{text}{Text to appear at top of list.}

\item{labels}{A character vector with the text to display inside the widget.
This can also be a list of html tag elements.  The text content of each
label or label name will be used to set the shiny \code{input_id} value.}

\item{input_id}{output variable to read the plot/image from.}

\item{css_id}{This is the css id to use, and must be unique in your shiny
app. This defaults to the value of \code{input_id}, and will be appended to the
value "rank-list-container", to ensure the CSS id is unique for the
container as well as the labels.
If NULL, the function generates an id of the form
\code{rank_list_id_1}, and will automatically increment for every \code{rank_list}.}

\item{options}{Options to be supplied to \link{sortable_js} object. See \link{sortable_options} for more details}

\item{orientation}{Set this to "horizontal" to get horizontal orientation of
the items.}

\item{class}{A css class applied to the rank list.  This can be used to
define custom styling.}
}
\description{
Creates a ranking item list using the \code{SortableJS} framework,
and generates an \code{htmlwidgets} element.  The elements of this list can be
dragged and dropped in any order.

You can embed a ranking question inside a \code{learnr} tutorial, using
\code{\link[=question_rank]{question_rank()}}.

To embed a \code{rank_list} inside a shiny app, see the Details section.
}
\details{
You can embed a \code{rank_list} inside a Shiny app, to capture the preferred
ranking order of your user.

The widget automatically updates a Shiny output, with the matching
\code{input_id}.
}
\examples{
## - example-rank-list ------------------------------------------------

if (interactive()) {
  rank_list(
    text = "You can drag, drop and re-order these items:",
    labels = c("one", "two", "three", "four", "five"),
    input_id = "example_2"
  )
}
## - example-rank-list-multidrag ------------------------------------------

if (interactive()) {
  rank_list(
    text = "You can select multiple items and drag as a group:",
    labels = c("one", "two", "three", "four", "five"),
    input_id = "example_2",
    options = sortable_options(
      multiDrag = TRUE
    )
  )
}
## - example-rank-list-swap -----------------------------------------------

if (interactive()) {
  rank_list(
    text = "You can re-order these items, and notice the swapping behaviour:",
    labels = c("one", "two", "three", "four", "five"),
    input_id = "example_2",
    options = sortable_options(
      swap = TRUE
    )
  )
}
## Example of a shiny app
if (interactive()) {
  app <- system.file("shiny-examples/rank_list/app.R", package = "sortable")
  shiny::runApp(app)
}

}
\seealso{
\link{update_rank_list}, \link{sortable_js}, \link{bucket_list} and \link{question_rank}
}
