% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainfallDetection.R
\name{rainfallDetection}
\alias{rainfallDetection}
\title{Rainfall detection}
\usage{
rainfallDetection(wave, method = "bedoya2017", ...)
}
\arguments{
\item{wave}{A Wave object to detect rainfall in}

\item{method}{Which rainfall detection method to use ("bedoya2017")}

\item{...}{Other arguments to pass to rain detection function}
}
\value{
Numeric value from the rainfall detection algorithm chosen.
}
\description{
Detects rainfall in a Wave. An uncalibrated version of Bedoya et al (2017) <doi:10.1016/j.ecolind.2016.12.018> is available in this package. The hardRain
package can also be accessed via this wrapper.
}
\examples{
\dontrun{
rainfallDetection(sheep, method="bedoya2017")
}

}
