% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.SOMnn.R
\docType{methods}
\name{predict,SOMnn-method}
\alias{predict,SOMnn-method}
\title{predict method for S4 class \code{SOMnn}}
\usage{
\S4method{predict}{SOMnn}(object, x)
}
\arguments{
\item{object}{object of type \code{SOMnn}.}

\item{x}{\code{data.frame} with rows of data to be predicted.}
}
\value{
\code{data.frame} with columns: 
                   \code{winner}, \code{x}, \code{y}, the predicted probabilities
                   for all categories and the prediction 
                   as category index (column name \code{prediction}) and
                   class label (column name \code{pred.class}).
}
\description{
Predicts categories for a table of data, based on the hexagonal som in the model.
This S4 method is a wrapper for the predict method stored in the slot \code{predict}
of a model of type SOMnn.
}
\details{
The function returns the winner neuron in \code{codes} for
each test vector in \code{x}.
\code{x} is organised as one vector per row and must have
the same number of columns (i.e. dimensions) and the identical column names 
as stored in the SOMnn object.

If data have been normalised during training, the same normalisation is applied
to the unknown data to be predicted.

Probablilities are softmax normalised by default.
}
\examples{
## get example data and add class labels:
data(iris)
species <- iris$Species

## train with default radius = diagonal / 2:
som <- som.nn.train(iris, class.col = "Species", 
                    xdim = 15, ydim = 9, alpha = 0.02, len = 10000, 
                    norm = TRUE, toroidal = FALSE)

## predict some samples:
unk <- iris[,!(names(iris) \%in\% "Species")]

setosa <- unk[species=="setosa",]
setosa <- setosa[sample(nrow(setosa), 20),]

versicolor <- unk[species=="versicolor",]
versicolor <- versicolor[sample(nrow(versicolor), 20),]

virginica <- unk[species=="virginica",]
virginica <- virginica[sample(nrow(virginica), 20),]

## predict with generic function:
predict(som, unk)

## predict with function in SOMnn object:
som@predict(setosa)
som@predict(versicolor)
som@predict(virginica)

## get mapping with visual:
som.nn.visual(som@codes, setosa)


## change parameters of k-NN classifier:
som.nn.set(som, iris, dist.fun = dist.fun.bubble, max.dist = 3.1)
som.nn.set(som, iris, dist.fun = dist.fun.tricubic, max.dist = 3)

## define custom distance function:
som <- som.nn.set(som, iris, dist.fun = function(x, sigma){
            ifelse(x < sigma, dnorm(x, sd = sigma), 0)}, 
            max.dist = 3)

predict(som, setosa)
som


}

