% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_rename.R
\name{core_rename}
\alias{core_rename}
\title{Rename a core}
\usage{
core_rename(name, other, async = NULL, raw = FALSE, callopts = list())
}
\arguments{
\item{name}{(character) The name of the core to be renamed. Required}

\item{other}{(character) The new name of the core. Required.}

\item{async}{(character) Request ID to track this action which will be processed
asynchronously}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Rename a core
}
\examples{
\dontrun{
# start Solr with Schemaless mode via the schemaless eg: bin/solr start -e schemaless
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
solr_connect()

# Status of particular cores
core_create("testcore") # or create in the CLI: bin/solr create -c testcore
core_rename("testcore", "newtestcore")
core_status("testcore") # core missing
core_status("newtestcore", FALSE) # not missing
}
}

