% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Solar.R
\name{Solar}
\alias{Solar}
\title{Calculating Solar Variables}
\usage{
Solar(DOY, Lat, Lon, SLon, DS, Elevation, Slope, Aspect)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude (in degrees)}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}

\item{Elevation}{Elevation of the site in meters}

\item{Slope}{Site slope in degrees}

\item{Aspect}{Site aspect with respect to the south in degrees}
}
\description{
This function calculates solar variables including radiation components, solar angles and positions and day length.
}
\examples{

#Calculating solar variables and angles

DOY <- seq(0, 2, .05)

solar <- Solar(DOY, Lat = 45, Lon=10, SLon=10, DS=0, Elevation = 1000, Slope = 10, Aspect = 0)
#Note: only the difference between Lon and SLon matters not each value

par(mfrow=c(3,1))
plot(DOY, solar$Altitude, ylim = c(-90,90))
plot(DOY, solar$Azimuth, col= 'red')

plot(DOY, solar$Sdiropen)
lines(DOY, solar$Sdifopen, col='red')

}
\keyword{Solar}
\keyword{Variables}
