\name{plot_profile}
\alias{plot_profile}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  The function which is called from the generic 'plot.profile.data.frame'
  %%  ~~function to do ... ~~
}
\description{
  This is the core function for plotting soil profile field data
  %%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
plot_profile(data, bottom = NULL, names = TRUE, names.col = "white",
background = "munsell", plot.roots = TRUE, plot.skeletal = TRUE,
random = TRUE, existing_data = NULL, horizon.border = NA, order = FALSE,
width = 480, element = FALSE, element.col = "black", element.legend =
FALSE, element.lims = FALSE, element.lab = FALSE, element.type = "b",
element.pch = 1, element.lty = 1, xax.log = FALSE, legend.labs = FALSE,
legend.pos = "bottom")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
    An object of class 'profile.data.frame' as generated by the
    'build.profile' function.
    %%     ~~Describe \code{data} here~~
  }
  \item{bottom}{
    A positive numeric value which controls the lower boundary of the
    plot. If not provided it defaults to the lower limit of the profile,
    or the lower limit of the deepest profile in case of multiple profiles.
    %%     ~~Describe \code{bottom} here~~
  }
  \item{names}{
    A logical value indicating whether the name of the horizons should be
    plotted (the default) or not in the soil profile.
    %%     ~~Describe \code{names} here~~
  }
  \item{names.col}{
    The color of the horizon names.
    %%     ~~Describe \code{names.col} here~~
  }
  \item{background}{
    The color background for the horizons. If background='munsell' (the
    defaul), color is determined by a call to the 'munsell_to_rgb'
    function. See the function for details on the conversion.
    %%     ~~Describe \code{background} here~~
  }
  \item{plot.roots}{
    A logical value indicating whether the roots should be plotted or
    not.
    %%     ~~Describe \code{plot.roots} here~~
  }
  \item{plot.skeletal}{
    A logical value indicating whether the skeletal should be plotted or
    not.
    %%     ~~Describe \code{plot.skeletal} here~~
  }
  \item{random}{
    A logical value indicating whether data for plotting elements (roots
    and skeletal) in the profile shuold be randomly generated or not. It
    defaults to TRUE and is required to be TRUE when you plot a profile
    for the first time. If you assign this first plot to an object, you
    can use such object in the following argument ('existing_data') to
    draw the same profile you have generated previously. Since the shapes
    are by default randomly generated, you can run
    'plot.profile.data.frame' more than once until you get the soil
    profile representation you like most. Remember to always assign a
    plot to an object so that you can retrieve it. See examples for
    details.
    %%     ~~Describe \code{random} here~~
  }
  \item{existing_data}{
    If random=FALSE, this is a complex list of elements for drawing the
    same soil profile(s) previously generated. See examples.
    %%     ~~Describe \code{existing_data} here~~
  }
  \item{horizon.border}{
    A color string. The default is NA, so that no horizon border is plotted.
    %%     ~~Describe \code{horizon.border} here~~
  }
  \item{order}{
    A vector of names that match the profile names in your dataset. This
    is used for multiple profile plots. The default is alphabetical order,
    so if you want a customized order use this argument.
    %%     ~~Describe \code{order} here~~
  }
  \item{width}{
    An integer value ranging approximately 150-1400. This number defaults
    to 480. It controls the 'layout' of multiple panels in a single
    figure. The default is optimized for plotting 3-4 profiles in a single
    figure. Lower widths are required for lower number of profiles and the
    other way around. Optimal width of plots is achieved by using the same
    width as argument of the plot function and as argument for width of
    your favorite graphical device. See examples.
    %%     ~~Describe \code{width} here~~
  }
  \item{element}{
    A character vector of one ore more parameters (chemical elements,
    etc.) to be plotted within the profile. Names must match colnames
    of your data. It defaults to FALSE, no element is plotted.
    %%     ~~Describe \code{element} here~~
  }
  \item{element.col}{
    A character vector of colors for plotting elements.
    %%     ~~Describe \code{element.col} here~~
  }
  \item{element.legend}{
    A logical value for plotting the legend.
    %%     ~~Describe \code{element.legend} here~~
  }
  \item{element.lims}{
    As for 'xlims' in plot, to set a unique limit for multiple elements
    in plot.
    %%     ~~Describe \code{element.lims} here~~
  }
  \item{element.lab}{
    A label for the x axis if element!=FALSE
    %%     ~~Describe \code{element.lab} here~~
  }
  \item{element.type}{
    One between 'n', 'b', 'l' as for 'plot', to define line type for
    element(s)  
    %%     ~~Describe \code{element.type} here~~
  }
  \item{element.pch}{
    As in 'pch' for 'plot'.
    %%     ~~Describe \code{element.pch} here~~
  }
  \item{element.lty}{
    As in 'lty', for 'plot'.
    %%     ~~Describe \code{element.lty} here~~
  }
  \item{xax.log}{
    A logical value for logaritmic x axis
    %%     ~~Describe \code{xax.log} here~~
  }
  \item{legend.labs}{
    if element.legend=TRUE, provide labs for legend
    %%     ~~Describe \code{legend.labs} here~~
  }
  \item{legend.pos}{
    Defaults to 'bottom'. The location may be specified by setting
    a single keyword from the list 'bottomright', 'bottom',
    'bottomleft', 'left', 'topleft', 'top', 'topright', 'right' and
     'center' as in 'legend'. However, the legend position defaults to
     bottom and is optimized for beeing set in the panel with the
     shallower profile. So 'bottom' will work in most cases.    
    %%     ~~Describe \code{legend.pos} here~~
  }
}
\details{
  This function is the core of the package and is written for plotting
  basic soil properties usually gathered in the field in a
  semi-quantitative way, for consistent representation of soil profile
  sketches. Those sketches are common in soil science publications and
  provide immediate feeling of what a given profile, or even better a
  sequence of soils look like morphologically. This function makes it
  possible to draw such profiles in few seconds and in a
  semi-quantitative way.
  Horizon boundaries are drawn according to the given depths. Irregular
  boundaries in the form of e.g. '0-12/23' cm are allowed, where it is
  ment that the lower boundary of such horizon fluctuates between 12
  and 23 cm. Stones (i.e. soil skeletal) are plotted within a soil
  horizon in three different shapes ('channer', 'subangular',
  'subcircle'), in whatever dimension expressed in cm, and with the
  abundance provided between 0 and 1. Abundance is computed exactly on
  an area basis for each horizon. Roots are drawn following the same
  approach as skeletal, except that root abundance is provided
  qualitatively, as it is a common practice in soil profile
  description. The color of a given horizon may be an RGB color that
  exactly reproduces the munsell color of the soil horizon.  
  %%  ~~ If necessary, more details than the description above ~~
}
\value{
  A complex list of all numeric values used in the plot are returned
  invisibly. The function can be however assigned for plotting the same
  soil profile more than once. See arguments 'random' and
  'existing_data' for more details.   
  %%  ~Describe the value returned
  %%  If it is a LIST, use
  %%  \item{comp1 }{Description of 'comp1'}
  %%  \item{comp2 }{Description of 'comp2'}
  %% ...
}
\author{
  Gianluca Filippa
  %%  ~~who you are~~
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  'eplot', 'build.profile', 'depths'
  %% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
## basic plot, assigned to an object
\dontrun{
tmp2 <- plot(example)
}

## a different plot (data for plotting are randomly generated each time,
## unless you assign and recycle it, like in following examples)
\dontrun{
plot(example)
}

## use existing_data and random=FALSE to get the same plot (if assigned)
 
\dontrun{
plot(example, random=FALSE, existing_data=example.data)
}

## esclude roots and skeletal from a plot

\dontrun{
plot(example, random=FALSE, existing_data=example.data, plot.roots=FALSE,
plot.skeletal=FALSE)
}

## a compex plot with an element added to the basic soil structure and a
## legend, and an overview of options

\dontrun{
plot(example, random=FALSE, existing_data=example.data, horizon.border='blue',
width=500, plot.roots=FALSE, plot.skeletal=FALSE, element='Corg',
element.lim=c(0, 27), element.col='black', names=FALSE, background='white',
element.lab='Organic carbon (percent)', element.legend=TRUE,
legend.labs='TOC')
}

## an optimal plotting with its graphical device, note the use of width
## both in the device and within the plot.
\dontrun{
png('myprofile.png', height=800, width=1200, pointsize=28)
plot(example, random=FALSE, existing_data=example.data, horizon.border='blue',
width=1200, plot.roots=FALSE, plot.skeletal=FALSE, element='Corg',
element.lim=c(0, 27), element.col='black', names=FALSE, background='white',
element.lab='Organic carbon (percent)', element.legend=TRUE,
legend.labs='TOC')
dev.off()
}
}


% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Plotting functions}
