% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_veg_data_from_NASIS_db.R
\name{get_veg_data_from_NASIS_db}
\alias{get_veg_data_from_NASIS_db}
\title{Get vegetation data from a local NASIS Database}
\usage{
get_veg_data_from_NASIS_db(SS = TRUE, dsn = NULL)
}
\arguments{
\item{SS}{get data from the currently loaded Selected Set in NASIS or from
the entire local database (default: \code{TRUE})}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A list of data.frame
}
\description{
Get vegetation data from a local NASIS Database. Result includes two data.frames corresponding to the "Plot Plant Inventory" and "Vegetation Transect" child tables of "Vegetation Plot".
}
\examples{

\donttest{
if(local_NASIS_defined()) {
 # query text note data
 v <- try(get_veg_from_NASIS_db())

 # show contents veg data returned
 str(v)
}
}

}
\author{
Jay M. Skovlin and Dylan E. Beaudette
}
\keyword{manip}
