% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchLDM.R
\name{fetchLDM}
\alias{fetchLDM}
\title{Query data from Kellogg Soil Survey Laboratory Data Mart via Soil Data Access or local SQLite snapshot}
\usage{
fetchLDM(
  x = NULL,
  what = "pedlabsampnum",
  bycol = "pedon_key",
  tables = c("lab_physical_properties", "lab_chemical_properties",
    "lab_calculations_including_estimates_and_default_values", "lab_rosetta_Key"),
  WHERE = NULL,
  chunk.size = 1000,
  ntries = 3,
  layer_type = c("horizon", "layer", "reporting layer"),
  area_type = c("ssa", "country", "state", "county", "mlra", "nforest", "npark"),
  prep_code = c("S", ""),
  analyzed_size_frac = c("<2 mm", ""),
  dsn = NULL
)
}
\arguments{
\item{x}{A vector of values to find in column specified by \code{what}, default \code{NULL} uses no constraints on \code{what}}

\item{what}{A single column name from tables: \code{lab_combine_nasis_ncss}, \code{lab_webmap}, \code{lab_site}, \code{lab_pedon} or \code{lab_area}}

\item{bycol}{A single column name from \code{lab_layer} used for processing chunks; default: \code{"pedon_key"}}

\item{tables}{A vector of table names; Default is \code{"lab_physical_properties"}, \code{"lab_chemical_properties"}, \code{"lab_calculations_including_estimates_and_default_values"}, and \code{"lab_rosetta_Key"}. May also include one or more of: \code{"lab_mir"}, \code{"lab_mineralogy_glass_count"}, \code{"lab_major_and_trace_elements_and_oxides"}, \code{"lab_xray_and_thermal"} but it will be necessary to select appropriate \code{prep_code} and \code{analyzed_size_frac} for your analysis (see \emph{Details}).}

\item{WHERE}{character. A custom SQL WHERE clause, which overrides \code{x}, \code{what}, and \code{bycol}, such as \verb{CASE WHEN corr_name IS NOT NULL THEN LOWER(corr_name) ELSE LOWER(samp_name) END = 'musick'}}

\item{chunk.size}{Number of pedons per chunk (for queries that may exceed \code{maxJsonLength})}

\item{ntries}{Number of tries (times to halve \code{chunk.size}) before returning \code{NULL}; default \code{3}}

\item{layer_type}{Default: \code{"horizon"}, \code{"layer"}, and \code{"reporting layer"}}

\item{area_type}{Default: \code{"ssa"} (Soil Survey Area). Other options include (choose one): \code{"country"}, \code{"state"}, \code{"county"}, \code{"mlra"} (Major Land Resource Area), \code{"nforest"} (National Forest), \code{"npark"} (National Park)}

\item{prep_code}{Default: \code{"S"} and \code{""}. May also include one or more of: \code{"F"}, \code{"HM"}, \code{"HM_SK"} \code{"GP"}, \code{"M"}, \code{"N"}, or \code{"S"}}

\item{analyzed_size_frac}{Default: \code{"<2 mm"} and \code{""}. May also include one or more of: \code{"<0.002 mm"}, \code{"0.02-0.05 mm"}, \code{"0.05-0.1 mm"}, \code{"0.1-0.25 mm"}, \code{"0.25-0.5 mm"}, \code{"0.5-1 mm"}, \code{"1-2 mm"}, \code{"0.02-2 mm"}, \code{"0.05-2 mm"}}

\item{dsn}{Data source name; either a path to a SQLite database, an open DBIConnection or (default) \code{NULL} (to use \code{soilDB::SDA_query})}
}
\value{
a \code{SoilProfileCollection} for a successful query, a \code{try-error} if no site/pedon locations can be found or \code{NULL} for an empty \code{lab_layer} (within sites/pedons) result
}
\description{
LDM model diagram: \url{https://jneme910.github.io/Lab_Data_Mart_Documentation/Documents/SDA_KSSL_Data_model.html}
}
\details{
If the \code{chunk.size} parameter is set too large and the Soil Data Access request fails, the algorithm will re-try the query with a smaller (halved) \code{chunk.size} argument. This will be attempted up to 3 times before returning \code{NULL}

Currently the \code{lab_area} tables are joined only for the "Soil Survey Area" related records.

When requesting data from \code{"lab_major_and_trace_elements_and_oxides"}, \code{"lab_mineralogy_glass_count"}, or \code{"lab_xray_and_thermal"} multiple preparation codes (\code{prep_code}) or size fractions (\code{analyzed_size_frac}) are possible. The default behavior of \code{fetchLDM()} is to attempt to return a topologically valid (minimal overlaps) \emph{SoilProfileCollection}. This is achieved by setting \code{prep_code="S"} ("sieved") and \code{analyzed_size_frac="<2 mm"}. You may specify alternate or additional preparation codes or fractions as needed, but note that this may cause "duplication" of some layers where measurements were made with different preparation or on fractionated samples
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  # fetch by ssa_key
  res <- fetchLDM(8297, what = "ssa_key")

  # physical properties correlated as taxonomic subgroup "Typic Argialbolls"
  res <- fetchLDM(x = "Typic Argialbolls", 
                  what = "corr_taxsubgrp", 
                  tables = "lab_physical_properties")

  # fetch by area_code (SSA only)  
  res <- fetchLDM("CA630", what = "area_code")
}
\dontshow{\}) # examplesIf}
}
