context("fetchHenry and related")

test_that("month2season() works as expected", {
  
  skip_on_cran()
  
  x <- c('Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec', 'Jan', 'Feb', 'Mar', 'Apr', 'May')
  res <- month2season(x)

  # classification
  expect_equivalent(as.character(res), c("Summer", "Summer", "Summer", "Fall", "Fall", "Fall", "Winter", "Winter", "Winter", "Spring", "Spring", "Spring"))

  # factor levels
  expect_equivalent(levels(res), c("Winter", "Spring", "Summer", "Fall"))

  # bogus input
  expect_true(
    is.na(month2season('da'))
  )

})



test_that("summarizeSoilTemperature() works as expected", {

  skip_on_cran()

  x <- structure(
    list(
      sid = rep(469L, 749),
      date_time = paste0(seq(as.Date("2007-12-05"), as.Date("2009-12-22"), length.out = 749), " 00:00:00"),
      sensor_value = c(8.23, 8.555, 8.82, 8.953,
                       8.62, 8.49, 8.23, 7.963, 7.83, 7.63, 7.43, 7.088, 7.02, 7.02,
                       7.02, 7.02, 7.02, 6.953, 6.687, 6.62, 6.62, 6.552, 6.21, 6.21,
                       6.01, 5.81, 5.943, 6.21, 6.077, 6.077, 6.21, 6.143, 6.143, 5.81,
                       5.81, 5.81, 5.81, 5.81, 5.81, 5.81, 5.81, 5.81, 5.81, 5.81, 5.537,
                       5.4, 5.4, 5.4, 5.19, 4.98, 4.912, 4.57, 4.57, 4.775, 4.98, 4.98,
                       4.57, 4.57, 4.29, 4.15, 4.01, 3.73, 3.73, 3.59, 3.73, 3.73, 3.73,
                       4.15, 4.57, 4.707, 4.98, 4.98, 4.98, 4.57, 4.57, 4.912, 4.98,
                       5.12, 5.4, 5.4, 5.33, 4.98, 4.98, 4.98, 5.33, 5.605, 5.81, 6.143,
                       6.143, 5.877, 5.81, 5.81, 5.81, 6.077, 6.21, 6.21, 6.21, 6.62,
                       6.887, 7.02, 7.02, 7.02, 6.753, 6.21, 6.21, 6.21, 6.347, 6.483,
                       6.483, 6.62, 6.687, 7.02, 7.02, 7.02, 7.02, 7.02, 7.293, 7.225,
                       7.02, 7.02, 7.362, 7.43, 7.497, 7.697, 7.763, 7.43, 7.43, 7.43,
                       7.63, 7.897, 8.36, 8.953, 9.02, 8.687, 8.62, 8.82, 9.02, 9.02,
                       8.555, 8.23, 8.23, 8.23, 8.23, 8.555, 9.02, 9.615, 9.877, 9.877,
                       9.68, 9.42, 9.81, 9.81, 9.877, 10.21, 10.47, 10.6, 10.6, 10.6,
                       10.99, 10.99, 10.99, 11.12, 11.38, 11.965, 12.477, 12.93, 13.247,
                       13.31, 13.31, 13.057, 12.735, 12.477, 12.095, 11.77, 11.51, 11.38,
                       11.38, 11.38, 11.77, 11.77, 12.16, 12.16, 12.54, 12.413, 12.54,
                       12.54, 12.54, 12.735, 12.93, 13.31, 13.31, 13.31, 13.763, 14.08,
                       14.08, 14.46, 14.46, 14.46, 14.85, 15.04, 15.23, 15.357, 15.357,
                       15.547, 15.61, 15.61, 15.61, 15.935, 16, 16, 16, 16, 16.123,
                       16, 16, 16.37, 16.63, 17.068, 17.455, 17.583, 17.583, 17.583,
                       17.647, 17.9, 17.9, 17.9, 17.837, 17.9, 17.9, 17.9, 17.647, 17.52,
                       17.583, 17.647, 17.837, 17.9, 17.9, 17.9, 17.773, 17.52, 17.647,
                       17.773, 17.9, 17.9, 17.963, 18.027, 18.28, 18.28, 18.28, 18.217,
                       17.963, 18.217, 18.28, 18.533, 18.66, 18.977, 19.04, 19.04, 18.787,
                       18.533, 18.28, 18.28, 18.28, 18.66, 18.66, 18.66, 18.66, 18.66,
                       18.913, 19.04, 18.977, 18.597, 18.28, 18.09, 18.153, 18.28, 18.28,
                       18.28, 18.533, 18.407, 18.28, 18.027, 17.9, 17.9, 17.9, 17.9,
                       17.9, 17.9, 17.9, 17.773, 17.52, 17.195, 17.007, 16.76, 16.76,
                       16.76, 17.13, 17.13, 17.13, 17.13, 17.195, 17.455, 17.52, 17.325,
                       17.068, 16.565, 16.123, 15.935, 15.805, 15.61, 15.483, 14.783,
                       14.207, 13.698, 13.31, 13.31, 13.505, 13.7, 14.08, 14.08, 14.08,
                       14.08, 14.08, 14.08, 14.08, 14.08, 14.08, 14.08, 14.08, 14.08,
                       14.08, 14.08, 14.08, 14.08, 13.57, 13.183, 12.735, 12.223, 11.965,
                       11.77, 11.77, 11.77, 11.38, 11.38, 11.38, 11.38, 11.38, 11.38,
                       11.575, 11.77, 11.77, 11.705, 11.445, 11.185, 10.99, 10.86, 10.86,
                       10.86, 10.99, 10.925, 10.6, 10.6, 10.6, 10.6, 10.405, 10.143,
                       9.81, 9.68, 9.42, 9.42, 9.087, 9.02, 8.753, 8.62, 8.62, 8.49,
                       8.097, 7.83, 7.43, 7.02, 6.753, 6.62, 6.21, 6.21, 6.21, 6.21,
                       5.943, 5.81, 5.537, 5.4, 5.4, 5.4, 5.4, 5.4, 5.537, 5.81, 5.742,
                       5.4, 5.4, 5.468, 5.742, 5.81, 5.81, 5.81, 5.81, 5.81, 6.143,
                       6.21, 6.21, 6.21, 6.552, 6.62, 6.62, 6.62, 6.887, 7.088, 7.563,
                       7.763, 7.293, 6.887, 6.415, 6.21, 6.21, 6.21, 6.21, 6.21, 6.21,
                       6.552, 6.62, 6.82, 6.887, 6.953, 6.82, 6.415, 6.01, 5.81, 5.468,
                       5.4, 4.98, 4.98, 4.638, 4.57, 4.57, 4.57, 4.912, 5.05, 5.468,
                       5.877, 6.21, 6.21, 6.483, 6.21, 6.552, 6.82, 7.02, 6.953, 6.552,
                       6.21, 6.21, 6.01, 5.74, 5.4, 5.33, 5.4, 5.4, 5.537, 5.81, 6.077,
                       6.21, 6.62, 6.953, 7.293, 7.43, 7.697, 6.82, 6.21, 6.21, 6.62,
                       7.02, 7.362, 7.83, 7.63, 7.43, 7.497, 7.83, 7.83, 7.697, 7.43,
                       7.497, 7.897, 7.963, 7.83, 7.83, 7.83, 7.83, 8.163, 8.62, 8.227,
                       7.83, 7.83, 8.295, 9.02, 9.812, 10.535, 11.185, 11.51, 11.575,
                       10.86, 10.34, 10.21, 10.143, 9.81, 9.81, 9.943, 10.21, 10.21,
                       10.405, 10.925, 11.25, 11.445, 11.77, 12.16, 12.223, 12.54, 12.54,
                       12.54, 12.54, 12.605, 12.993, 13.505, 14.08, 14.46, 14.46, 14.27,
                       14.397, 14.46, 14.46, 14.27, 14.27, 14.525, 14.913, 15.23, 15.357,
                       15.61, 15.61, 15.357, 15.04, 14.913, 14.527, 13.89, 13.7, 13.89,
                       14.08, 14.08, 14.08, 14.08, 14.08, 14.08, 14.08, 14.08, 14.46,
                       14.85, 15.23, 15.42, 15.23, 14.977, 15.23, 15.61, 16, 16.123,
                       16.37, 16.76, 17.13, 17.52, 17.455, 17.52, 17.52, 17.647, 17.647,
                       17.583, 17.325, 17.068, 16.945, 16.883, 16.945, 17.13, 17.13,
                       17.39, 17.583, 17.963, 18.28, 18.66, 18.723, 19.04, 19.103, 19.04,
                       19.04, 19.04, 18.913, 19.04, 19.04, 19.23, 19.293, 19.42, 19.42,
                       19.357, 19.23, 19.103, 18.977, 18.787, 18.47, 17.71, 17.52, 17.647,
                       17.963, 18.343, 18.66, 18.787, 18.787, 18.407, 18.217, 18.28,
                       18.47, 18.723, 19.04, 19.103, 19.357, 19.23, 18.85, 18.787, 18.723,
                       18.66, 18.913, 19.04, 19.04, 19.103, 19.167, 19.04, 19.357, 19.357,
                       19.167, 18.787, 18.343, 18.027, 17.9, 18.027, 18.28, 18.66, 18.47,
                       18.027, 17.325, 17.13, 17.13, 17.52, 17.583, 17.71, 17.583, 17.9,
                       17.9, 17.9, 17.9, 17.9, 18.09, 18.09, 17.963, 17.01, 16.185,
                       16, 15.805, 15.42, 14.718, 14.207, 14.08, 14.08, 14.08, 14.08,
                       14.08, 14.08, 13.953, 13.7, 14.017, 14.08, 14.46, 14.525, 14.655,
                       14.017, 13.375, 13.057, 13.183, 13.31, 13.31, 13.31, 13.247,
                       12.543, 11.575, 11.12, 10.99, 11.324, 11.445, 11.835, 12.16,
                       12.03, 11.64, 11.445, 11.185, 10.925, 10.99, 10.99, 10.99, 10.47,
                       9.943, 9.615, 9.42, 9.42, 9.42, 9.287, 9.02, 9.02, 8.82, 8.753,
                       8.62, 8.62, 8.62, 8.62, 8.62, 8.23, 7.83, 7.83, 7.83, 7.563,
                       7.43, 7.43, 7.02, 6.687, 6.278, 6.143, 5.81, 5.81, 5.943, 6.21,
                       6.21, 6.21, 6.347, 6.62, 6.62, 6.62, 6.687, 7.02, 7.02)
    ),
    class = "data.frame",
    row.names = c(NA, 749L)
  )

  s <- .formatDates(x, gran = 'day', pad.missing.days = TRUE, tz = "GMT")
  salt <- .formatDates(x, gran = 'day', pad.missing.days = FALSE)

  expect_equivalent(nrow(s), 1096) # filled
  expect_equivalent(nrow(salt), 749) # not filled

  res <- summarizeSoilTemperature(s)

  expect_equivalent(nrow(res), 1)

  expect_equivalent(res$days.of.data, 749L)

  expect_equal(res$gap.index, 0.32)

  expect_equivalent(res$functional.yrs, 2L)

  expect_equivalent(res$complete.yrs, 1L)

  expect_equal(res$MAST, 11.65, tolerance = 0.1)

  expect_equal(res$Winter, 6.15, tolerance = 0.1)

  expect_equal(res$Summer, 16.94, tolerance = 0.1)

  expect_equivalent(as.character(res$STR), 'mesic')

})


test_that(".fill_missing_days() works as expected", {
  
  skip_on_cran()
  
  x <- data.frame(
    sid = 1,
    date_time = as.POSIXct('2010-02-17 00:00:00'),
    sensor_value = 1,
    year = 2010,
    doy = 48,
    month = 'Feb',
    season = 'Winter',
    water_year = 2010,
    water_day = 140
  )

  res <- .fill_missing_days(x)

  # there should be 365 records
  expect_true(nrow(res) == 365)

  ## TODO more tests

})


test_that(".formatDates() works as expected", {
  
  skip_on_cran()
  
  x <- data.frame(
    sid = c(1L, 2L),
    date_time = c("2010-02-17 10:00:00", "2021-01-01 10:00:00"),
    sensor_value = c(40.000, 5.5),
    stringsAsFactors = FALSE
  )

  # .formatDates tz argument ensures consistency of tests across platforms/locales
  res <- soilDB:::.formatDates(x, gran = 'day', pad.missing.days = FALSE, tz = "GMT")

  # expected structure
  expect_true(nrow(res) == nrow(x))

  expect_equivalent(res$sid, x$sid)

  expect_true(inherits(res$date_time, 'POSIXct'))

  expect_equivalent(res$sensor_value, x$sensor_value)

  expect_equivalent(res$year, c(2010L, 2021L))

  expect_equivalent(res$doy, c(48L, 1L))

  expect_equivalent(as.character(res$month), c('Feb', 'Jan'))

  expect_equivalent(res$water_year, c(2010L, 2021L))

  expect_equivalent(res$water_day, c(140L, 93L))

})
