\name{loafercreek}
\alias{loafercreek}

\alias{andic.subset}
\alias{gopheridge}

\docType{data}
\title{LoaferCreek Soils}
\description{A SoilProfileCollection Object of Loafercreek Soils from the CA630 Soil Survey Area.}
\usage{data(loafercreek)}
\format{\preformatted{Formal class 'SoilProfileCollection' [package "aqp"] with 7 slots
  ..@ idcol     : chr "pedon_id"
  ..@ depthcols : chr [1:2] "hzdept" "hzdepb"
  ..@ metadata  :'data.frame':	1 obs. of  1 variable:
  .. ..$ depth_units: chr "cm"
  ..@ horizons  :'data.frame':	312 obs. of  29 variables:
  .. ..$ phiid          : int [1:312] 1258320 1258321 1258322 1258323 1258324 1258325 2068689 2068690 2068691 2068692 ...
  .. ..$ pedon_id       : chr [1:312] "07SKC003" "07SKC003" "07SKC003" "07SKC003" ...
  .. ..$ hzname         : chr [1:312] "A" "Bt1" "Bt2" "2Bt3" ...
  .. ..$ hzdept         : int [1:312] 0 10 23 33 48 64 0 1 4 12 ...
  .. ..$ hzdepb         : int [1:312] 10 23 33 48 64 64 1 4 12 28 ...
  .. ..$ clay           : num [1:312] 15 19 32 38 28 NA NA 16 18 25 ...
  .. ..$ silt           : num [1:312] 50 61 55 49 NA NA NA NA NA NA ...
  .. ..$ sand           : num [1:312] 35 20 13 13 NA NA NA NA NA NA ...
  .. ..$ texture_class  : chr [1:312] "l" "sil" "sicl" "sicl" ...
  .. ..$ phfield        : num [1:312] 6.8 6.7 6.9 6.9 6.7 ...
  .. ..$ effervescence  : chr [1:312] NA NA NA NA ...
  .. ..$ labsampnum     : chr [1:312] NA NA NA NA ...
  .. ..$ total_frags_pct: int [1:312] 10 24 5 10 23 0 0 10 10 18 ...
  .. ..$ d_r            : num [1:312] 0.525 0.637 0.541 0.525 0.616 ...
  .. ..$ d_g            : num [1:312] 0.34 0.441 0.331 0.34 0.452 ...
  .. ..$ d_b            : num [1:312] 0.158 0.248 0.185 0.158 0.218 ...
  .. ..$ m_r            : num [1:312] 0.399 0.525 0.541 0.525 0.525 ...
  .. ..$ m_g            : num [1:312] 0.251 0.34 0.331 0.34 0.34 ...
  .. ..$ m_b            : num [1:312] 0.113 0.158 0.185 0.158 0.158 ...
  .. ..$ taxon_kind     : chr [1:312] "series" "series" "series" "series" ...
  .. ..$ soil_color     : chr [1:312] "#66401D" "#865728" "#8A542F" "#865728" ...
  .. ..$ gravel         : num [1:312] 10 16 5 10 0 NA NA 10 10 18 ...
  .. ..$ paragravel     : num [1:312] 0 0 0 0 18 NA NA 0 0 0 ...
  .. ..$ cobbles        : num [1:312] 0 0 0 0 0 NA NA 0 0 0 ...
  .. ..$ paracobbles    : num [1:312] 0 8 0 0 5 NA NA 0 0 0 ...
  .. ..$ stones         : num [1:312] 0 0 0 0 0 NA NA 0 0 0 ...
  .. ..$ boulders       : num [1:312] 0 0 0 0 0 NA NA 0 0 0 ...
  .. ..$ channers       : num [1:312] 0 0 0 0 0 NA NA 0 0 0 ...
  .. ..$ flagstones     : num [1:312] 0 0 0 0 0 NA NA 0 0 0 ...
  ..@ site      :'data.frame':	53 obs. of  45 variables:
  .. ..$ pedon_id       : chr [1:53] "07SKC003" "09BAH008" "09CKS001" "09CKS006" ...
  .. ..$ peiid          : int [1:53] 268820 493742 342445 374201 374205 374216 374219 374232 542131 530603 ...
  .. ..$ site_id        : chr [1:53] "07CA630SKC003" "09CA630BAH008" "09CA630CKS001" "09CA630CKS006" ...
  .. ..$ siteiid        : int [1:53] 269617 501286 342696 374485 374489 374500 374503 374516 550825 540897 ...
  .. ..$ sampled_as     : chr [1:53] "Motherlode" "Loafercreek" "Loafercreek active" "Loafercreek" ...
  .. ..$ correlated_as  : chr [1:53] "LOAFERCREEK" "Loafercreek" "Loafercreek" "Loafercreek" ...
  .. ..$ hillslope_pos  : chr [1:53] "Backslope" "Footslope" "Backslope" "Backslope" ...
  .. ..$ datum          : chr [1:53] "NAD83" "NAD83" "NAD83" "NAD83" ...
  .. ..$ elev           : num [1:53] 328 384 1014 210 202 ...
  .. ..$ slope          : num [1:53] 9 3 22 29 4 36 50 18 22 32 ...
  .. ..$ aspect         : int [1:53] 344 102 220 235 115 185 185 335 45 52 ...
  .. ..$ plantassocnm   : chr [1:53] "Blue Oak Woodland" "Blue Oak Woodland/Grassland" "Blue Oak Woodland" ...
  .. ..$ bedrckdepth       : int [1:53] 64 68 110 86 96 72 93 65 72 70 ...
  .. ..$ bedrock_kind      : chr [1:53] "Greenstone" "Metavolcanics" "Greenstone" "Greenstone" ...
  .. ..$ bedrock_hardness  : chr [1:53] NA "Noncemented" NA NA ...
  .. ..$ describer         : chr [1:53] "Stacy Kavanaugh" "Bev Harben" "Chris Savastio" "Chris Savastio" ...
  .. ..$ psctopdepth       : int [1:53] 23 12 9 3 2 12 8 5 6 25 ...
  .. ..$ pscbotdepth       : int [1:53] 64 62 59 53 52 57 58 55 56 70 ...
  .. ..$ part_size_class   : chr [1:53] "fine-loamy" "fine-loamy" "fine-loamy" "fine-loamy" ...
  .. ..$ tax_subgroup      : chr [1:53] "Ultic Haploxeralfs" "Ultic Haploxeralfs" "Ultic Haploxeralfs" "Ultic Haploxeralfs" ...
  .. ..$ obs_date          : POSIXct[1:53], format: "2007-03-21" "2009-06-03" "2009-03-23" "2009-04-14" ...
  .. ..$ pedon_purpose     : chr [1:53] "full pedon description" "full pedon description" "full pedon description" NA ...
  .. ..$ pedon_type        : chr [1:53] "within range of series" "within range of series" "modal pedon for series" ...
  .. ..$ pedlabsampnum     : chr [1:53] NA NA "S09CA009002" NA ...
  .. ..$ ochric.epipedon   : logi [1:53] TRUE TRUE TRUE TRUE TRUE TRUE ...
  .. ..$ cambic.horizon    : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ paralithic.contact: logi [1:53] TRUE TRUE TRUE TRUE TRUE TRUE ...
  .. ..$ lithic.contact    : logi [1:53] FALSE FALSE TRUE FALSE FALSE FALSE ...
  .. ..$ mollic.epipedon   : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ argillic.horizon  : logi [1:53] TRUE TRUE TRUE TRUE TRUE TRUE ...
  .. ..$ umbric.epipedon   : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ paralithic.materials     : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ lithologic.discontinuity : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ andic.soil.properties    : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ densic.contact           : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ aquic.conditions         : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ duripan                  : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ slickensides             : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ kandic.horizon           : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ redox.depletions.with.chroma.2.or.less: logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ reduced.matrix           : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ abrupt.textural.change   : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ calcic.horizon           : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ redox.concentrations     : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  .. ..$ limnic.material          : logi [1:53] FALSE FALSE FALSE FALSE FALSE FALSE ...
  ..@ sp        :Formal class 'SpatialPoints' [package "sp"] with 3 slots
  .. .. ..@ coords     : num [1:53, 1:2] -120 -121 -121 -121 -121 ...
  .. .. .. ..- attr(*, "dimnames")=List of 2
  .. .. .. .. ..$ : chr [1:53] "248" "406" "495" "500" ...
  .. .. .. .. ..$ : chr [1:2] "x" "y"
  .. .. ..@ bbox       : num [1:2, 1:2] -120.8 37.7 -120.4 38.2
  .. .. .. ..- attr(*, "dimnames")=List of 2
  .. .. .. .. ..$ : chr [1:2] "x" "y"
  .. .. .. .. ..$ : chr [1:2] "min" "max"
  .. .. ..@ proj4string:Formal class 'CRS' [package "sp"] with 1 slots
  .. .. .. .. ..@ projargs: chr " +proj=longlat +datum=NAD83 +ellps=GRS80 +towgs84=0,0,0"
  ..@ diagnostic:'data.frame':	169 obs. of  5 variables:
  .. ..$ pedon_id : chr [1:169] "07SKC003" "07SKC003" "07SKC003" "09BAH008" ...
  .. ..$ peiid    : int [1:169] 268820 268820 268820 493742 493742 493742 342445 342445 342445 342445 ...
  .. ..$ diag_kind: chr [1:169] "ochric epipedon" "argillic horizon" "paralithic contact" "ochric epipedon" ...
  .. ..$ featdept : int [1:169] 0 23 64 1 12 68 0 9 97 110 ...
  .. ..$ featdepb : int [1:169] 23 64 NA 12 68 100 9 97 110 NA ..
}}

\examples{
require(reshape)
data(loafercreek)

##
## aggregate major horizon types over 1cm intervals
##

# categorize major horizon types
hz.tab <- rev(sort(table(loafercreek$hzname)))
hz.tab[hz.tab > 5]

# add generalized hz name
loafercreek$hz <- rep(NA, times=nrow(horizons(loafercreek)))

# generalize horizons
loafercreek$hz[grep('O', loafercreek$hzname)] <- 'O'
loafercreek$hz[grep('A', loafercreek$hzname)] <- 'A'
loafercreek$hz[grep('Bt', loafercreek$hzname)] <- 'Bt'
loafercreek$hz[grep('Cr', loafercreek$hzname)] <- 'Cr'
loafercreek$hz[grep('R', loafercreek$hzname)] <- 'R'

# convert generalized hz to factor
loafercreek$hz <- factor(loafercreek$hz)
loafercreek.hz.agg <- slab(loafercreek, fm= ~ hz)

# wide->long format
loafercreek.hz.agg.long <- melt(loafercreek.hz.agg, 
id.var=c('top','bottom', 'contributing_fraction', 'all.profiles', 'variable'), 
variable_name='horizon')

# plot horizon type proportions
require(lattice)
xyplot(top ~ value, groups=horizon, data=loafercreek.hz.agg.long, ylim=c(150, -5), 
type=c('S','g'), horizontal=TRUE, subset=value > 0, asp=1.5, ylab='', xlab='', 
auto.key=list(columns=5, lines=TRUE, points=FALSE))
}

\keyword{datasets}
