% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tools.r
\name{cowboy_cut}
\alias{cowboy_cut}
\title{Cut ordinal variables}
\usage{
cowboy_cut(x, top.share = 0.1, bottom.share = 0.1, missing = "Missing")
}
\arguments{
\item{x}{a factor}

\item{top.share}{approximate share in top category}

\item{bottom.share}{approximate share in bottom category}

\item{missing}{a character vector with all the missing or unwanted categories.}
}
\value{
a recoded factor
}
\description{
If we are in a hurry and need to cut a lot of likert-scale or similar type of variables into MCA-friendly ordered factors this function comes in handy.
cowboy_cut will try its best to create approx 3-5 categories, where the top and the bottom are smaller than the middle. Missing or other unwanted categories are recoded but still influence the categorization. So that when cowboy_cut tries to part the top of a variable with a threshold around 10% of cases it is 10% including the missing or NA cases.
Make sure that levels are in the right order before cutting.
}
