% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.snowboot.R
\name{plot.snowboot}
\alias{plot.snowboot}
\title{Plot Degree Distribution Estimates}
\usage{
\method{plot}{snowboot}(x, k = NULL, plotmu = TRUE,
  plotlegend = TRUE, col0 = "gray50", lwd0 = 1,
  colpt = "royalblue3", lwdpt = 2, pchpt = 4, coli = "palegreen3",
  colibg = "palegreen", length = 0.1, boxwex = 0.4,
  legendargs = list(x = "topright", cex = 0.9, bty = "n"), las = 1,
  ...)
}
\arguments{
\item{x}{output of \code{\link{lsmi_dd}}, \code{\link{boot_dd}}, or \code{\link{boot_ci}}.}

\item{k}{an integer vector with degrees to plot.
By default, all degrees represented in \code{x} are plotted.}

\item{plotmu}{logical value indicating whether to plot the results for mean degree
(default is \code{TRUE}).}

\item{plotlegend}{logical value indicating whether to plot a legend
(default is \code{TRUE}).}

\item{col0}{color to plot horizontal zero-line at \eqn{f(k) = 0}.
Use \code{NA} for no plotting.}

\item{lwd0}{width of the horizontal zero-line at \eqn{f(k) = 0}.}

\item{colpt}{color for plotting point estimates.}

\item{lwdpt}{line width for plotting point estimates.}

\item{pchpt}{point type for plotting point estimates
(see argument \code{pch} in \code{\link[graphics]{points}}).}

\item{coli}{color for plotting lines or borders of box-plots for bootstrap estimates.}

\item{colibg}{background color, if plotting boxplots of bootstrapped estimates
(see argument \code{border} in \code{\link[graphics]{boxplot}}).}

\item{length}{length of arrows, if plotting bootstrap confidence intervals
(see argument \code{length} in \code{\link[graphics]{arrows}}).}

\item{boxwex}{argument of \code{\link[graphics]{boxplot}} function.}

\item{legendargs}{additional arguments for plotting the legend
(see arguments in \code{\link[graphics]{legend}}).}

\item{las}{argument of \code{\link[graphics]{plot}} function.}

\item{...}{additional arguments to pass to the \code{\link[graphics]{plot}} function.}
}
\description{
Plot LSMI-based point estimates of probabilities of node degrees, \eqn{\hat{f}(k)}, and
of mean degree, \eqn{\hat{\mu}}, where \eqn{k = 0, 1, \ldots} are the degrees.
The point estimates are supplemented with box-and-whisker plots
of bootstrapped values (if the input is a \code{\link{boot_dd}} output) or element-wise
bootstrap confidence intervals (if the input is a \code{\link{boot_ci}} output).
See \insertCite{chen_etal_2018_snowboot;textual}{snowboot}.
}
\examples{
net <- artificial_networks[[1]]
x <- lsmi_dd(net = net, n.wave = 2, n.seed = 40)
plot(x)

x2 <- boot_dd(x)
plot(x2, k = c(1:10))

x3 <- boot_ci(x2, prob = 0.99)
plot(x3, k = c(1:10))

}
\references{
\insertAllCited{}
}
