% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNION_LSMI.R
\name{Union_LSMI}
\alias{Union_LSMI}
\title{Snowball sampling with multiple inclusion.}
\usage{
Union_LSMI(net, n.seeds, n.neigh, seeds = NULL)
}
\arguments{
\item{net}{A network object that is list containing:
\describe{
  \item{edges}{The edgelist of the network. A two column
    \code{matrix} where each row is an edge.}
  \item{degree}{The degree sequence of the network, which is
    an \code{integer} vector of length n.}
  \item{n}{The network order.}
}
  The object can be created by \code{\link{local.network.MR.new5}} or
  it can be imported.}

\item{n.seeds}{A numeric vector of seeds for snowball sampling.
It must be a positive integers.}

\item{n.neigh}{A numeric vector of waves to be sampled around each seed in LSMI.
For example, n.neigh = 0 corresponds to seeds only, and n.neigh = 1
corresponds to sampling seeds and their first neighbors).
Note that the algorithm allows for multiple inclusions.}

\item{seeds}{A matrix of dimension \code{num.sam} x \code{n.seeds} containing the
numeric ids of the seeds to initiate sampling. Each row of the matrix
corresponds to one LSMI sample. Note that this is an optional parameter.
WARNING: As of now, this feature is only supported when
parameter \code{n.neigh} is greater than zero.}
}
\value{
A list containing LSMI objects
}
\description{
The function will creat a list of LSMI objects. The function is primairly
used in cross-validation.
}
\note{
see \code{\link{LSMI}.}
}
\examples{
net <- artificial_networks[[1]]
a <- Union_LSMI(net, n.seeds = c(5,10), n.neigh = 1:2)
}
\references{
Thompson, M. E., Ramirez Ramirez, L. L., Lyubchich, V. and
 Gel, Y. R. (2015), Using the bootstrap for statistical inference
 on random graphs. Can J Statistics. doi: 10.1002/cjs.11271
}

