\name{evcent}
\alias{evcent}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Find Eigenvector Centrality Scores of Network Positions }
\description{
  \code{evcent} takes one or more graphs (\code{dat}) and returns the eigenvector centralities of positions (selected by \code{nodes}) within the graphs indicated by \code{g}.  This function is compatible with \code{\link{centralization}}, and will return the theoretical maximum absolute deviation (from maximum) conditional on size (which is used by \code{\link{centralization}} to normalize the observed centralization score).
}
\usage{
evcent(dat, g=1, nodes=NULL, gmode="digraph", diag=FALSE,
    tmaxdev=FALSE, rescale=FALSE, ignore.eval=FALSE, tol=1e-10,
    maxiter=1e5, use.eigen=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{dat}{ one or more input graphs. }
  \item{g}{ integer indicating the index of the graph for which centralities are to be calculated (or a vector thereof).  By default, \code{g}=1. }
  \item{nodes}{ vector indicating which nodes are to be included in the calculation.  By default, all nodes are included. }
  \item{gmode}{ string indicating the type of graph being evaluated.  "digraph" indicates that edges should be interpreted as directed; "graph" indicates that edges are undirected.  This is currently ignored. }
  \item{diag}{ boolean indicating whether or not the diagonal should be treated as valid data.  Set this true if and only if the data can contain loops.  \code{diag} is \code{FALSE} by default. }
  \item{tmaxdev}{ boolean indicating whether or not the theoretical maximum absolute deviation from the maximum nodal centrality should be returned.  By default, \code{tmaxdev==FALSE}. }
  \item{rescale}{ if true, centrality scores are rescaled such that they sum to 1. }
  \item{ignore.eval}{ logical; should edge values be ignored?}
  \item{tol}{ convergence tolerance for the eigenvector computation.}
  \item{maxiter}{ maximum iterations for eigenvector calculation.}
  \item{use.eigen}{ logical; should we use R's \code{\link{eigen}} routine instead of the (faster but less robust) internal method?}
}
\details{
Eigenvector centrality scores correspond to the values of the first eigenvector of the graph adjacency matrix; these scores may, in turn, be interpreted as arising from a reciprocal process in which the centrality of each actor is proportional to the sum of the centralities of those actors to whom he or she is connected.  In general, vertices with high eigenvector centralities are those which are connected to many other vertices which are, in turn, connected to many others (and so on).  (The perceptive may realize that this implies that the largest values will be obtained by individuals in large cliques (or high-density substructures).  This is also intelligible from an algebraic point of view, with the first eigenvector being closely related to the best rank-1 approximation of the adjacency matrix (a relationship which is easy to see in the special case of a diagonalizable symmetric real matrix via the \eqn{S \Lambda S^{-1}}{SLS^-1} decomposition).) 

By default, a sparse-graph power method is used to obtain the principal eigenvector.  This procedure scales well, but may not converge in some cases.  In the event that the convergence objective set by \code{tol} is not obtained, \code{evcent} will return a warning message.  Correctives in this case include increasing \code{maxiter}, or setting \code{use.eigen} to \code{TRUE}.  The latter will cause \code{evcent} to use R's standard \code{\link{eigen}} method to calculate the principal eigenvector; this is far slower for sparse graphs, but is also more robust.

The simple eigenvector centrality is generalized by the Bonacich power centrality measure; see \code{\link{bonpow}} for more details.
}
\value{
  A vector, matrix, or list containing the centrality scores (depending on the number and size of the input graphs).
}
\references{ Bonacich, P.  (1987).  ``Power and Centrality: A Family of Measures.'' \emph{American Journal of Sociology}, 92, 1170-1182.

Katz, L.  (1953).  ``A New Status Index Derived from Sociometric Analysis.''  \emph{Psychometrika}, 18, 39-43.
 }
\author{ Carter T. Butts \email{buttsc@uci.edu} }
\note{ The theoretical maximum deviation used here is not obtained with the star network, in general.  For symmetric data, the maximum occurs for an empty graph with one complete dyad; the maximum deviation for asymmetric data is generated by the outstar.  UCINET V seems not to adjust for this fact, which can cause some oddities in their centralization scores (and results in a discrepancy in centralizations between the two packages). }

\section{WARNING }{\code{evcent} will not symmetrize your data before extracting eigenvectors; don't send this routine asymmetric matrices unless you really mean to do so.}

\seealso{ \code{\link{centralization}}, \code{\link{bonpow}} }

\examples{

#Generate some test data
dat<-rgraph(10,mode="graph")
#Compute eigenvector centrality scores
evcent(dat)
}
\keyword{ univar }%-- one or more ...
\keyword{ math }
\keyword{ graphs }
