# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Mean of a matrix (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon.
#'
#' @param mat_aux a numeric matrix.
#' @return The mean of \code{mat_aux}.
#' @keywords internal
NULL

#' @title Matern covariance function (scalar - generic)
#'
#' @description Computing the Matern covariance function for a single distance
#'   measure, addapted from \code{geoR}.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Matern covariance function,
#'   controls the differentiability of the process.
#'
#' @return a scalar representing the (matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_matern}}, \code{\link{single_matern5}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_matern <- function(d, sigsq, phi, nu) {
    .Call(`_smile_single_matern`, d, sigsq, phi, nu)
}

#' @title Matern covariance function (scalar - nu = 3/2)
#'
#' @description Computing the Matern covariance function for a single distance
#'   measure, with \eqn{\nu = 3/2}.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_matern}}, \code{\link{single_matern5}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_matern3 <- function(d, sigsq, phi) {
    .Call(`_smile_single_matern3`, d, sigsq, phi)
}

#' @title Matern covariance function (scalar - nu = 5/2)
#'
#' @description Computing the Matern covariance function for a single distance
#'   measure, with \eqn{\nu = 5/2}.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' 
#' @seealso \code{\link{single_matern}}, \code{\link{single_matern3}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_matern5 <- function(d, sigsq, phi) {
    .Call(`_smile_single_matern5`, d, sigsq, phi)
}

#' @title Exponential covariance function (scalar)
#'
#' @description Computing the Exponential covariance function for a single
#'   distance measure.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Exponential covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Exponential covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (exponential) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' 
#' @seealso \code{\link{single_pexp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#' 
#' @keywords internal
single_exp <- function(d, sigsq, phi) {
    .Call(`_smile_single_exp`, d, sigsq, phi)
}

#' @title Matern covariance function for a given distance matrix.
#'
#' @description Computing the Matern covariance function for a matrix of
#'   distances.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Matern covariance function,
#'   controls the differentiability of the process.
#' 
#' @return The matern covariance function (for a stationary and isotropic
#'   process) associated with the provided distances (\code{dists}) and the
#'   given set of parameters.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}}
#' 
#' @keywords internal
mat_cov <- function(dists, sigsq, phi, nu) {
    .Call(`_smile_mat_cov`, dists, sigsq, phi, nu)
}

#' @title Mean of a (Matern) covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Matern covariance function,
#'   controls the differentiability of the process.
#' 
#' @return The mean of \code{mat_cov(dist, sigsq, phi, nu)}.
#' @keywords internal
aux_matern <- function(dist, sigsq, phi, nu) {
    .Call(`_smile_aux_matern`, dist, sigsq, phi, nu)
}

#' @title Matern covariance function for a polygons.
#'
#' @description Computing the Matern covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Matern covariance function,
#'   controls the differentiability of the process. Note that, if we set
#'   \code{nu = .5}, then the calculations are based on the exponential
#'   covariance function.
#' 
#' @return The matern covariance matrix associated with a set of polygons.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{mat_cov}}
#' 
#' @keywords internal
comp_mat_cov <- function(cross_dists, n, n2, sigsq, phi, nu) {
    .Call(`_smile_comp_mat_cov`, cross_dists, n, n2, sigsq, phi, nu)
}

#' @title Powered Exponential covariance function (scalar)
#'
#' @description Computing the Powered Exponential covariance function for a
#'   single distance measure.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Exponential covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Exponential covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu \in (0, 2]} parameter representing the "power"
#'
#' @return a scalar representing the (exponential) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_pexp <- function(d, sigsq, phi, nu) {
    .Call(`_smile_single_pexp`, d, sigsq, phi, nu)
}

#' @title Powered Exponential covariance function for a given distance matrix.
#'
#' @description Computing the Matern covariance function for a matrix of
#'   distances.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Exponential covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Exponential covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the \eqn{\nu \in (0, 2]} parameter representing the "power"
#' 
#' @return The powered exponential covariance function (for a stationary and
#'   isotropic process) associated with the provided distances (\code{dists})
#'   and the given set of parameters.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}}
#' @keywords internal
pexp_cov <- function(dists, sigsq, phi, nu) {
    .Call(`_smile_pexp_cov`, dists, sigsq, phi, nu)
}

#' @title Mean of a (Powered Exponential) covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Powered Exponential
#'   covariance function.
#' @param phi the \eqn{\phi} parameter from the Powered Exponential covariance
#'   function, controls the range of the spatial dependence.
#' @param nu the \eqn{\nu} parameter from the Powered Exponential
#'   covariance function,
#'   controls the differentiability of the process.
#' 
#' @return The mean of \code{pexp_cov(dist, sigsq, phi, nu)}.
#' @keywords internal
aux_pexp <- function(dist, sigsq, phi, nu) {
    .Call(`_smile_aux_pexp`, dist, sigsq, phi, nu)
}

#' @title Powered Exponential covariance function for a polygons.
#'
#' @description Computing the Powered Exponential covariance function between
#'   polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} parameter from the Powered Exponential
#'   covariance function.
#' @param phi the \eqn{\phi} parameter from the Powered Exponential covariance
#'   function, controls the range of the spatial dependence.
#' @param nu the \eqn{\nu \in (0, 2]} parameter representing the "power"
#' 
#' @return The powered exponential covariance matrix associated with a set of
#'   polygons.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
comp_pexp_cov <- function(cross_dists, n, n2, sigsq, phi, nu) {
    .Call(`_smile_comp_pexp_cov`, cross_dists, n, n2, sigsq, phi, nu)
}

#' @title Gaussian covariance function (scalar)
#'
#' @description Computing the Gaussian covariance function for a single
#'   distance measure.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Gaussian covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Gaussian covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (gaussian) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_gauss <- function(d, sigsq, phi) {
    .Call(`_smile_single_gauss`, d, sigsq, phi)
}

#' @title Computing the Gaussian covariance function for a single distance
#'   measure.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Gaussian covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Gaussian covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return The Gaussian covariance function (for a stationary and
#'   isotropic process) associated with the provided distances (\code{dists})
#'   and the given set of parameters.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}}
#'
#' @keywords internal
gauss_cov <- function(dists, sigsq, phi) {
    .Call(`_smile_gauss_cov`, dists, sigsq, phi)
}

#' @title Mean of a (Gaussian) covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Gaussian covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Gaussian covariance function,
#'   controls the range of the spatial dependence.
#' 
#' @return The mean of \code{gauss_cov(dist, sigsq, phi)}.
#'
#' @keywords internal
aux_gauss <- function(dist, sigsq, phi) {
    .Call(`_smile_aux_gauss`, dist, sigsq, phi)
}

#' @title Gaussian covariance function for a polygons.
#'
#' @description Computing the Gaussian covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} parameter from the Gaussian covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Gaussian covariance function,
#'   controls the range of the spatial dependence.
#' 
#' @return The gaussian covariance matrix associated with a set of
#'   polygons.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{mat_cov}}
#' 
#' @keywords internal
comp_gauss_cov <- function(cross_dists, n, n2, sigsq, phi) {
    .Call(`_smile_comp_gauss_cov`, cross_dists, n, n2, sigsq, phi)
}

#' @title Spherical covariance function (scalar)
#'
#' @description Computing the Spherical covariance function for a single
#'   distance measure.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (gaussian) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_spher <- function(d, sigsq, phi) {
    .Call(`_smile_single_spher`, d, sigsq, phi)
}

#' @title Computing the Spherical covariance function for a single distance
#'   measure.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#''
#' @return The Spherical covariance function (for a stationary and
#'   isotropic process) associated with the provided distances (\code{dists})
#'   and the given set of parameters.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}}
#'
#' @keywords internal
spher_cov <- function(dists, sigsq, phi) {
    .Call(`_smile_spher_cov`, dists, sigsq, phi)
}

#' @title Mean of a (Spherical) covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#' 
#' @return The mean of \code{spher_cov(dist, sigsq, phi)}.
#'
#' @keywords internal
aux_spher <- function(dist, sigsq, phi) {
    .Call(`_smile_aux_spher`, dist, sigsq, phi)
}

#' @title Spherical covariance function for a polygons.
#'
#' @description Computing the Spherical covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#' 
#' @return The spherical covariance matrix associated with a set of
#'   polygons.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
comp_spher_cov <- function(cross_dists, n, n2, sigsq, phi) {
    .Call(`_smile_comp_spher_cov`, cross_dists, n, n2, sigsq, phi)
}

#' @title Cubic spline covariance function (scalar)
#'
#' @description Computing the Spherical covariance function for a single
#'   distance measure.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#'
#' @return a scalar representing the (gaussian) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{single_matern3}}, \code{\link{single_matern5}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
single_cs <- function(d, sigsq, phi) {
    .Call(`_smile_single_cs`, d, sigsq, phi)
}

#' @title Computing the Cubic spline covariance function for a single distance
#'   measure.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#''
#' @return The Spherical covariance function (for a stationary and
#'   isotropic process) associated with the provided distances (\code{dists})
#'   and the given set of parameters.
#'
#'
#' @keywords internal
cs_cov <- function(dists, sigsq, phi) {
    .Call(`_smile_cs_cov`, dists, sigsq, phi)
}

#' @title Mean of a (Cubic spline) covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance.
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#' 
#' @return The mean of \code{spher_cov(dist, sigsq, phi)}.
#'
#' @keywords internal
aux_cs <- function(dist, sigsq, phi) {
    .Call(`_smile_aux_cs`, dist, sigsq, phi)
}

#' @title Cubic spline covariance function for a polygons.
#'
#' @description Computing the Spherical covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} parameter from the Spherical covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Spherical covariance function,
#'   controls the range of the spatial dependence.
#' 
#' @return The spherical covariance matrix associated with a set of
#'   polygons.
#'
#' @seealso \code{\link{single_exp}}, \code{\link{single_matern}},
#'   \code{\link{mat_cov}}
#'
#' @keywords internal
comp_cs_cov <- function(cross_dists, n, n2, sigsq, phi) {
    .Call(`_smile_comp_cs_cov`, cross_dists, n, n2, sigsq, phi)
}

#' @title Matern Generalized Wendland (GW) covariance function with kappa = 0
#'   (scalar - generic)
#'
#' @description adapted from Bevilacqua et al. 2019.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param mu a parameter that controls the smoothness of the covariance
#'   function. Note that, \eqn{\mu \geq 1}.
#' 
#' @return a scalar representing the GW covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @keywords internal
single_gw0 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw0`, d, sigsq, phi, mu)
}

#' @title Matern Generalized Wendland (GW) covariance function with kappa = 1
#'   (scalar - generic)
#'
#' @description adapted from Bevilacqua et al. 2019.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param mu a parameter that controls the smoothness of the covariance
#'   function. Note that, \eqn{\mu \geq 1}.
#' 
#' @return a scalar representing the GW covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @keywords internal
single_gw1 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw1`, d, sigsq, phi, mu)
}

#' @title Matern Generalized Wendland (GW) covariance function with kappa = 2
#'   (scalar - generic)
#'
#' @description adapted from Bevilacqua et al. 2019.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param mu a parameter that controls the smoothness of the covariance
#'   function. Note that, \eqn{\mu \geq 1}.
#' 
#' @return a scalar representing the GW covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @keywords internal
single_gw2 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw2`, d, sigsq, phi, mu)
}

#' @title Matern Generalized Wendland (GW) covariance function with kappa = 3
#'   (scalar - generic)
#'
#' @description adapted from Bevilacqua et al. 2019.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param mu a parameter that controls the smoothness of the covariance
#'   function. Note that, \eqn{\mu \geq 1}.
#' 
#' @return a scalar representing the GW covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @keywords internal
single_gw3 <- function(d, sigsq, phi, mu) {
    .Call(`_smile_single_gw3`, d, sigsq, phi, mu)
}

#' @title Matern Generalized Wendland (GW) covariance function with kappa = 0
#'   (scalar - generic)
#'
#' @description adapted from Bevilacqua et al. 2019.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param kappa \eqn{\kappa \in \{0, \ldots, 3 \}}.
#' @param mu a parameter that controls the smoothness of the covariance
#'   function. Note that, \eqn{\mu \geq 1}.
#' 
#' @return a scalar representing the GW covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @keywords internal
single_gw <- function(d, sigsq, phi, kappa, mu) {
    .Call(`_smile_single_gw`, d, sigsq, phi, kappa, mu)
}

#' @title Generalized Wendland covariance function for a given distance matrix.
#'
#' @description Computing the Matern covariance function for a matrix of
#'   distances.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi \eqn{\phi} is the range of the covariance function.
#' @param kappa \eqn{\kappa \in \{0, \ldots, 3 \}}.
#' @param mu \eqn{\mu} controls the smoothness of the covariance function
#' @return The GW (isotropic) covariance function associated with the provided
#'   distances (\code{dists}) and the given set of parameters.
#' 
#' @keywords internal
gw_cov <- function(dists, sigsq, phi, kappa, mu) {
    .Call(`_smile_gw_cov`, dists, sigsq, phi, kappa, mu)
}

#' @title Mean of a Generalized Wendland covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} variance of the covariance function
#'   function.
#' @param phi the \eqn{\phi} is the range parameter of the covariance function.
#' @param kappa \eqn{\kappa \in \{0, \ldots, 3 \}}.
#' @param mu \eqn{\mu} controls the smoothness of the covariance function
#' @return The mean of \code{mat_cov(dist, sigsq, phi, kappa)}.
#' @keywords internal
aux_gw <- function(dist, sigsq, phi, kappa, mu) {
    .Call(`_smile_aux_gw`, dist, sigsq, phi, kappa, mu)
}

#' @title Generalized Wendland covariance function for a polygons.
#'
#' @description Computing the Matern covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} variance of the covariance function
#'   function.
#' @param phi the \eqn{\phi} is the range parameter of the covariance function.
#' @param kappa \eqn{\kappa \in \{0, \ldots, 3 \}}.
#' @param mu \eqn{\mu} controls the smoothness of the covariance function
#' @return The wendland-1 covariance matrix associated with a set of polygons.
#' 
#' @keywords internal
comp_gw_cov <- function(cross_dists, n, n2, sigsq, phi, kappa, mu) {
    .Call(`_smile_comp_gw_cov`, cross_dists, n, n2, sigsq, phi, kappa, mu)
}

#' @title Matern (tappered) covariance function (scalar - generic)
#'
#' @description Computing the Matern covariance function for a single distance
#'   measure, addapted from \code{geoR} using Wendland-1 as a tapper.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param nu the smoothness parameter \eqn{\nu} from the Matern covariance
#'   function, controls the differentiability of the process.
#'
#' @param theta the \eqn{\theta} tapper range.
#'
#' @return a scalar representing the (tappered matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_matern}}, \code{\link{single_matern5}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_tapmat <- function(d, sigsq, phi, nu, theta) {
    .Call(`_smile_single_tapmat`, d, sigsq, phi, nu, theta)
}

#' @title Tappered Matern covariance function (scalar - nu = 1/2)
#'
#' @description Computing the Matern covariance function for a single distance
#'   measure, with \eqn{\nu = 1/2}.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param theta \eqn{\theta} taper range.
#'
#' @return a scalar representing the (tappered matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_matern}}, \code{\link{single_matern5}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_tapmat1 <- function(d, sigsq, phi, theta) {
    .Call(`_smile_single_tapmat1`, d, sigsq, phi, theta)
}

#' @title Tappered Matern covariance function (scalar - nu = 3/2)
#'
#' @description Computing the Matern covariance function for a single distance
#'   measure, with \eqn{\nu = 3/2}.
#'
#' @param d a scalar representing the distance on which it is desired to
#'   evaluate the covariance function.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#'   controls the range of the spatial dependence.
#' @param theta \eqn{\theta} taper range.
#'
#' @return a scalar representing the (tappered matern) covariance between two
#'   observations \code{d} apart of each other.
#' 
#' @seealso \code{\link{single_matern}}, \code{\link{single_matern5}}
#'   \code{\link{single_exp}}, \code{\link{mat_cov}}
#' 
#' @keywords internal
single_tapmat3 <- function(d, sigsq, phi, theta) {
    .Call(`_smile_single_tapmat3`, d, sigsq, phi, theta)
}

#' @title Tappered Matern covariance function for a given distance matrix.
#'
#' @description Computing the tappered Matern covariance function for a matrix
#'   of
#'   distances.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,'
#' @param nu smoothness parameter
#' @param theta \eqn{\theta} taper range.
#' 
#' @return The tappered matern covariance function (for a stationary and isotropic
#'   process) associated with the provided distances (\code{dists}) and the
#'   given set of parameters.
#' 
#' @keywords internal
tapmat_cov <- function(dists, sigsq, phi, nu, theta) {
    .Call(`_smile_tapmat_cov`, dists, sigsq, phi, nu, theta)
}

#' @title Mean of a (Matern - Wendland-1 tapper) covariance function (Internal use)
#'
#' @description This is an auxilliary function for internal use. It helps to
#'   numerically integrate a covariance function evaluated at a grid of points
#'   within a polyigon and speed-up the computations.
#'
#' @param dists a numeric matrix representing the distance between spatial
#'   entities.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function,
#' @param nu
#' @param theta
#' @return The mean of \code{mat_cov(dist, sigsq, phi, nu)}.
#' @keywords internal
aux_tapmat <- function(dist, sigsq, phi, nu, theta) {
    .Call(`_smile_aux_tapmat`, dist, sigsq, phi, nu, theta)
}

#' @title Wendland-1 covariance function for a polygons.
#'
#' @description Computing the Matern covariance function between polygons.
#'
#' @param cross_dists a \code{list} such that each position contains the cross
#'   distances between points within different polygons.
#' @param n an ingeger representing number of polygons (note that, this is
#'   different than the size of the list \code{cross_dists}
#' @param n2 usually, equal to \code{n}, except when the function is being used
#'   to calculate the "cross" covariance between two different partitions of
#'   the same space.
#' @param sigsq the \eqn{\sigma^2} parameter from the Matern covariance
#'   function.
#' @param phi the \eqn{\phi} parameter from the Matern covariance function
#' @param nu the smoothness parameter \eqn{\nu} parameter from the Matern
#'   covariance function
#' @param theta the taper distance.
#' @return The wendland-1 covariance matrix associated with a set of polygons.
#' 
#' @keywords internal
comp_tapmat_cov <- function(cross_dists, n, n2, sigsq, phi, nu, theta) {
    .Call(`_smile_comp_tapmat_cov`, cross_dists, n, n2, sigsq, phi, nu, theta)
}

#' @name aux_mat
#' @keywords internal
NULL

#' @title Creatin a distance matrix
#' 
#' @description Internal use. For now it only supports euclidean distance. (May
#'   import parallelDist in the future).
#'
#' @param my_mat a matrix representing a grid of points.
#' @keywords internal
distmat <- function(my_mat) {
    .Call(`_smile_distmat`, my_mat)
}

#' @title Pairwise distances between matrices
#' 
#' @description Internal use.
#'
#' @param m1 a matrix representing a grid of points within a polygon.
#' @param m2 a matrix representing a grid of points within a polygon.
#'
#' @keywords internal
crossdist <- function(m1, m2) {
    .Call(`_smile_crossdist`, m1, m2)
}

#' @title Internal use only
#' @param mat_list internal use
#' @param mat_list1 internal use
#' @param mat_list2 internal use
#' @param x internal use
#' @param y internal use
#' @param return_single internal use
#' @param pred_mat internal use
#' @param x_to_list internal use
#' @param by internal use
#' @param y_grid internal use
#' @param x_grid internal use
#' @param tr_vec index for distance truncation
#' @param tr_inp truncation input
#' @name aux_mat
#' @keywords internal
single_dists <- function(mat_list) {
    .Call(`_smile_single_dists`, mat_list)
}

#' @name aux_mat
#' @keywords internal
single_dists_tr <- function(mat_list, tr_vec, tr_inp) {
    .Call(`_smile_single_dists_tr`, mat_list, tr_vec, tr_inp)
}

#' @name aux_mat//'
#' @keywords internal
mult_dists <- function(mat_list1, mat_list2, return_single) {
    .Call(`_smile_mult_dists`, mat_list1, mat_list2, return_single)
}

#' @name aux_mat
#' @keywords internal
pred_cdist <- function(mat_list, pred_mat) {
    .Call(`_smile_pred_cdist`, mat_list, pred_mat)
}

