% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slfm_list.r
\name{slfm_list}
\alias{slfm_list}
\title{Fitting the SLFM to a group of data matrices within a directory.}
\usage{
slfm_list(path = ".", recursive = TRUE, a = 2.1, b = 1.1,
  gamma_a = 1, gamma_b = 1, omega_0 = 0.01, omega_1 = 10,
  sample = 1000, burnin = round(0.25 * sample), lag = 1,
  degenerate = FALSE)
}
\arguments{
\item{path}{path to the directory where the target data matrices are located.}

\item{recursive}{logical argument (default = TRUE) indicating whether the function should look recursively 
inside folders.}

\item{a}{positive shape parameter of the Inverse Gamma prior distribution (default = 2.1).}

\item{b}{positive scale parameter of the Inverse Gamma prior distribution (default = 1.1).}

\item{gamma_a}{positive 1st shape parameter of the Beta prior distribution (default = 1).}

\item{gamma_b}{positive 2nd shape parameter of the Beta prior distribution (default = 1).}

\item{omega_0}{prior variance of the spike mixture component (default = 0.01).}

\item{omega_1}{prior variance of the slab mixture component (default = 10).}

\item{sample}{sample size to be considered for inference after the burn in period (default = 1000).}

\item{burnin}{size of the burn in period in the MCMC algorithm (default = sample/4).}

\item{lag}{lag to build the chains based on spaced draws from the Gibbs sampler (default = 1).}

\item{degenerate}{logical argument (default = FALSE) indicating whether to use the degenerate version of 
the mixture prior for the factor loadings.}
}
\description{
This function is used to fit the Bayesian Sparse
Latent Factor Model to all numeric matrices located in a directory.
}
