% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{reorder.slca}
\alias{reorder.slca}
\title{Reorder Latent Class Membership of Class Variables}
\usage{
\method{reorder}{slca}(x, ...)
}
\arguments{
\item{x}{an object of class \code{slca} and \code{estimated}.}

\item{...}{additional arguments specifying the new order for the latent class variables.}
}
\value{
Returns the modified \code{slca} or \code{estimated} object with the reordered latent classes.
}
\description{
This function reorders the latent class membership for specified latent class variables.
}
\examples{
library(magrittr)
nlsy_jlcpa \%>\% param

# Reorder the RHO parameters as ascending order
reordered1 <- nlsy_jlcpa \%>\%
   reorder(smk98 = c(2, 3, 1),
           drk98 = c(2, 1, 3),
           mrj98 = c(3, 2, 1))
reordered1 \%>\% param
# Label class1: nonuse
#       class2: lifetime use
#       class3: current use

# Reorder the TAU parameters for joint classes as ascending order
reordered2 <- reordered1 \%>\%
   reorder(use98 = c(5, 1, 4, 2, 3))
reordered2 \%>\% param
# Label class1: nonuse
#       class2: heavy drinking only
#       class3: not heavy use
#       class4: heavy drinking & smoking
#       class5: heavy use

# Reorder the TAU paramters for profiles as ascending order
reordered3 <- reordered2 \%>\%
   reorder(prof = c(4, 1, 3, 2))
reordered3 \%>\% param
# Label class1: nonuse stayer
#       class2: heavy drinking advancer
#       class3: heavy drk & smk advancer
#       class4: heavy use advancer
}
