% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_onexit.R
\name{register_onexit}
\alias{register_onexit}
\title{Append slackr_msg as on.exit to functions.}
\usage{
register_onexit(
  f,
  ...,
  header_msg = NULL,
  use_device = FALSE,
  env = parent.frame(2),
  channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  token = Sys.getenv("SLACK_TOKEN")
)
}
\arguments{
\item{f}{function or character.}

\item{...}{expressions to be sent to Slack.}

\item{header_msg}{boolean, message to append to start of Slack output, Default: NULL.}

\item{use_device}{boolean, passes current image in the graphics device to Slack as part of f,
Default: FALSE.}

\item{env}{environment to assign appended function to with relation to the function environment,
Default: parent.frame(2) (global environment).}

\item{channel}{Channel, private group, or IM channel to send message to. Can be an encoded ID, or a name. See the \href{https://api.slack.com/methods/chat.postMessage#channels}{chat.postMessage endpoint documentation} for details.}

\item{username}{what user should the bot be named as (chr).}

\item{icon_emoji}{what emoji to use (chr) \code{""} will mean use the default.}

\item{token}{Authentication token bearing required scopes.}
}
\value{
function
}
\description{
Appends to the body of a function an on.exit call to run at the end of the call.
}
\details{
If a character is passed to f then it will evaluate internally to a function.
}
\examples{
\dontrun{
ctl <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
trt <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
group <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
weight <- c(ctl, trt)

# pass a message to Slack channel 'general'
register_onexit(lm, "bazinga!", channel = "#general")

lm.D9 <- slack_lm(weight ~ group)

# test that output keeps inheritance
summary(lm.D9)

# pass a message to Slack channel 'general' with a header message to begin output
register_onexit(
  lm,
  "bazinga!",
  channel = "#general",
  header_msg = "This is a message to begin"
)

lm.D9 <- slack_lm(weight ~ group)

# onexit with an expression that calls lm.plot
register_onexit(
  lm,
  {
    par(mfrow = c(2, 2), oma = c(0, 0, 2, 0))
    plot(z)
  },
  channel = "#general",
  header_msg = "This is a plot just for this output",
  use_device = TRUE
)

lm.D9 <- slack_lm(weight ~ group)

# clean up slack channel from examples
slackr_delete(count = 6, channel = "#general")
}

}
\seealso{
\code{\link[=slackr_msg]{slackr_msg()}}
}
\author{
Jonathan Sidi (aut)
}
