% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanics.R
\name{orbit}
\alias{orbit}
\title{Calculate visible path of celestial object at given location}
\usage{
orbit(dec, loc, res = 0.25, refraction, atm, temp)
}
\arguments{
\item{dec}{Declination of object.}

\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude and longitude of location, in this order.}

\item{res}{The resolution (in degrees of RA) with which to calculate the path.}

\item{refraction}{(Optional) Whether atmospheric refraction is to be taken into account.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}
}
\description{
This function calculates the visible path of a celestial
object from any location on earth. It outputs a \emph{skyscapeR.orbit}
object, which includes AZ and ALT information.
}
\examples{
# Visible path of sun on june solstice on year 3999 BC from London:
sun.dec <- jS(-4000)
london.lat <- 51.5074 #N
london.lon <- -0.1278 #W
loc <- c( london.lat, london.lon, 0 )
path <- orbit(sun.dec, loc)
plot(path$az, path$alt, ylim=c(0,90), type='l', xlab='AZ', ylab='ALT', col='red', lwd=2)
}
