% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{antizenith}
\alias{antizenith}
\title{Declination of the anti-zenith sun for a given location}
\usage{
antizenith(loc)
}
\arguments{
\item{loc}{This can be either the latitude of the
location, or a \emph{skyscapeR.horizon} object.}
}
\description{
This function returns the declination of the sun
when it is at the anti-zenith, or nadir, for a given
location. If this phenomena does not occur at given
location (i.e. if location is outside the tropical
band) the function returns a \emph{NULL} value.
}
\examples{
# Anti-zenith sun declination for Mexico City:
antizenith(19.419)

# There is no anti-zenith sun phenomena in London:
antizenith(51.507)
}
\seealso{
\code{\link{jS}}, \code{\link{dS}}, \code{\link{eq}}, \code{\link{zenith}}
}
