% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skim_obj.R
\name{skim-attr}
\alias{skim-attr}
\alias{data_rows}
\alias{data_cols}
\alias{df_name}
\alias{group_names}
\alias{base_skimmers}
\alias{skimmers_used}
\title{Functions for accessing skim_df attributes}
\usage{
data_rows(object)

data_cols(object)

df_name(object)

group_names(object)

base_skimmers(object)

skimmers_used(object)
}
\arguments{
\item{object}{A \code{skim_df} or \code{skim_list}.}
}
\value{
Data contained within the requested \code{skimr} attribute.
}
\description{
These functions simplify access to attributes contained within a \code{skim_df}.
While all attributes are read-only, being able to extract this information
is useful for different analyses. These functions should always be preferred
over calling base R's attribute functions.
}
\section{Functions}{
\itemize{
\item \code{data_rows}: Get the number of rows in the skimmed data frame.

\item \code{data_cols}: Get the number of columns in the skimmed data frame.

\item \code{df_name}: Get the name of the skimmed data frame. This is only
available in contexts where the name can be looked up. This is often not
the case within a pipeline.

\item \code{group_names}: Get the names of the groups in the original data frame.
Only available if the data was grouped. Otherwise, \code{NULL}.

\item \code{base_skimmers}: Get the names of the base skimming functions used.

\item \code{skimmers_used}: Get the names of the skimming functions used, separated
by data type.
}}

