% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped.R
\name{fam2ped}
\alias{fam2ped}
\title{Fam to pedigree}
\usage{
fam2ped(fam)
}
\arguments{
\item{fam}{A tibble with six columns of PLINK .fam data as read in by \link{read_fam}.}
}
\value{
A tibble with new listcol \code{ped} containing pedigrees from \code{kinship2::pedigree}.
}
\description{
Converts a \href{https://www.cog-genomics.org/plink/1.9/formats#fam}{PLINK-formatted fam file} to a pedigree object using \link[kinship2:pedigree]{kinship2::pedigree}.
}
\examples{
famfile <- system.file("extdata", "3gens.fam", package="skater", mustWork=TRUE)
fam <- read_fam(famfile)
fam2ped(fam)

}
