% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\alias{pca_rotate}
\title{Tidy summary of Principal Component Analysis}
\usage{
pca(x)

pca_rotate(x, nf = NULL, rotation = c("varimax", "quartimax", "promax",
  "oblimin", "simplimax", "cluster", "none"))
}
\arguments{
\item{x}{A data frame or a \code{\link[stats]{prcomp}} object.}

\item{nf}{Number of components to extract. If \code{rotation = "varmiax"}
and \code{nf = NULL}, number of components is based on the Kaiser-criteria.}

\item{rotation}{Rotation of the factor loadings. May be one of
\code{"varimax", "quartimax", "promax", "oblimin", "simplimax", "cluster"}
or \code{"none"}.}
}
\value{
A tidy data frame with either all loadings of principal components
   (for \code{pca()}) or a rotated loadings matrix (for \code{pca_rotate()}).
}
\description{
...
}
\details{
The \code{print()}-method for \code{pca_rotate()} has a
   \code{cutoff}-argument, which is a scalar between 0 and 1, indicating
   which (absolute) values from the loadings should be blank in the
   output. By default, all loadings below .1 (or -.1) are not shown.
}
\examples{
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

# extract principal components
pca(efc[, start:end])

# extract principal components, varimax-rotation.
# number of components based on Kaiser-criteria
pca_rotate(efc[, start:end])

}
