% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc.R
\name{re_var}
\alias{re_var}
\alias{get_re_var}
\title{Random effect variances}
\usage{
re_var(x, adjusted = FALSE)

get_re_var(x, comp = c("tau.00", "tau.01", "tau.11", "rho.01",
  "sigma_2"))
}
\arguments{
\item{x}{Fitted mixed effects model (of class \code{merMod}, \code{glmmTMB},
\code{stanreg} or \code{brmsfit}). \code{get_re_var()} also accepts
an object returned by the \code{\link{icc}} function.}

\item{adjusted}{Logical, if \code{TRUE}, returns the variance of the fixed
and random effects as well as of the additive dispersion and
distribution-specific variance, which are used to calculate the
adjusted and conditional \code{\link{r2}} and \code{\link{icc}}.}

\item{comp}{Name of the variance component to be returned. See 'Details'.}
}
\value{
\code{get_re_var()} returns the value of the requested variance component,
          \code{re_var()} returns all random effects variances.
}
\description{
These functions extracts random effect variances as well as
               random-intercept-slope-correlation of mixed effects models.
               Currently, \code{\link[lme4]{merMod}}, \code{\link[glmmTMB]{glmmTMB}},
               \code{stanreg} and \code{\link[brms]{brmsfit}}
               objects are supported.
}
\details{
The random effect variances indicate the between- and within-group
        variances as well as random-slope variance and random-slope-intercept
        correlation. Use following values for \code{comp} to get the particular
        variance component:
        \describe{
         \item{\code{"sigma_2"}}{Within-group (residual) variance}
         \item{\code{"tau.00"}}{Between-group-variance (variation between individual intercepts and average intercept)}
         \item{\code{"tau.11"}}{Random-slope-variance (variation between individual slopes and average slope)}
         \item{\code{"tau.01"}}{Random-Intercept-Slope-covariance}
         \item{\code{"rho.01"}}{Random-Intercept-Slope-correlation}
        }
        The within-group-variance is affected by factors at level one, i.e.
        by the lower-level direct effects. Level two factors (i.e. cross-level
        direct effects) affect the between-group-variance. Cross-level
        interaction effects are group-level factors that explain the
        variance in random slopes (Aguinis et al. 2013).
        \cr \cr
        If \code{adjusted = TRUE}, the variance of the fixed and random
        effects as well as of the additive dispersion and
        distribution-specific variance are returned (see \cite{Johnson et al. 2014}
        and \cite{Nakagawa et al. 2017}):
        \describe{
         \item{\code{"fixed"}}{variance attributable to the fixed effects}
         \item{\code{"random"}}{(mean) variance of random effects}
         \item{\code{"dispersion"}}{variance due to additive dispersion}
         \item{\code{"distribution"}}{distribution-specific variance}
         \item{\code{"residual"}}{sum of dispersion and distribution}
        }
}
\examples{
library(lme4)
fit1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# all random effect variance components
re_var(fit1)
re_var(fit1, adjusted = TRUE)

# just the rand. slope-intercept covariance
get_re_var(fit1, "tau.01")

sleepstudy$mygrp <- sample(1:45, size = 180, replace = TRUE)
fit2 <- lmer(Reaction ~ Days + (1 | mygrp) + (Days | Subject), sleepstudy)
re_var(fit2)

}
\references{
\itemize{
   \item Aguinis H, Gottfredson RK, Culpepper SA. 2013. Best-Practice Recommendations for Estimating Cross-Level Interaction Effects Using Multilevel Modeling. Journal of Management 39(6): 1490–1528 (\doi{10.1177/0149206313478188})
   \item Johnson PC, O'Hara RB. 2014. Extension of Nakagawa & Schielzeth's R2GLMM to random slopes models. Methods Ecol Evol, 5: 944-946. (\doi{10.1111/2041-210X.12225})
   \item Nakagawa S, Johnson P, Schielzeth H (2017) The coefficient of determination R2 and intra-class correlation coefficient from generalized linear mixed-effects models revisted and expanded. J. R. Soc. Interface 14. \doi{10.1098/rsif.2017.0213}
 }
}
\seealso{
\code{\link{icc}}
}
