% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{write_stata}
\alias{write_stata}
\title{Write content of data frame to STATA dta-file}
\usage{
write_stata(x, path, use.tagged.na = FALSE, enc.to.utf8 = FALSE,
  version = 14)
}
\arguments{
\item{x}{\code{data.frame} that should be saved as file.}

\item{path}{File path of the output file.}

\item{use.tagged.na}{Logical, if \code{TRUE}, \code{\link[haven]{tagged_na}}
values are converted to their values, i.e. values of tagged NA's are
converted to factor levels. If \code{FALSE} (default), tagged NA's
are converted to regular NA's.}

\item{enc.to.utf8}{Logical, if \code{TRUE}, character encoding of variable and
value labels will be converted to UTF-8.}

\item{version}{File version to use. Supports versions 8-14.}
}
\description{
This function saves the content of a data frame to an STATA dta-file.
}
\note{
You don't need to take care whether variables have been imported with
        the \code{\link{read_stata}} function from this package or from \pkg{haven},
        or if you have imported STATA data and
        created new variables. This function does all necessary data preparation
        to write a properly labelled STATA file.
}
\seealso{
\code{\link{write_spss}}
}

