% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotDist.R
\name{dist_norm}
\alias{dist_norm}
\title{Plot normal distributions}
\usage{
dist_norm(norm = NULL, mean = 0, sd = 1, p = NULL, xmax = NULL,
  geom.colors = NULL, geom.alpha = 0.7)
}
\arguments{
\item{norm}{numeric, optional. If specified, a normal distribution with \code{mean} and \code{sd}
is plotted and a shaded area at \code{norm} value position is plotted that
indicates whether or not the specified value is significant or not.
If both \code{norm} and \code{p} are not specified, a distribution without shaded
area is plotted.}

\item{mean}{numeric. Mean value for normal distribution. By default 0.}

\item{sd}{numeric. Standard deviation for normal distribution. By default 1.}

\item{p}{numeric, optional. If specified, a normal distribution with \code{mean} and \code{sd}
is plotted and a shaded area at the position where the specified p-level
starts is plotted. If both \code{norm} and \code{p} are not specified, a distribution
without shaded area is plotted.}

\item{xmax}{numeric, optional. Specifies the maximum x-axis-value. If not specified, the x-axis
ranges to a value where a p-level of 0.00001 is reached.}

\item{geom.colors}{User defined color palette for shaded areas. If specified, must either be vector with color values
of same length as groups defined in \code{x}, or a specific color palette code (see below).
\itemize{
  \item If not specified, the qualitative \code{"Paired"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
  \item Else specify your own color values as vector (e.g. \code{geom.colors = c("#f00000", "#00ff00")}).
}}

\item{geom.alpha}{specified the alpha-level of the shaded area. Default is 0.7, range between 0 to 1.}
}
\description{
This function plots a simple normal distribution or a normal distribution
               with shaded areas that indicate at which value a significant p-level
               is reached.
}
\examples{
# a simple normal distribution
dist_norm()

# a simple normal distribution with different mean and sd.
# note that curve looks similar to above plot, but axis range
# has changed.
dist_norm(mean = 2, sd = 4)

# a simple normal distribution
dist_norm(norm = 1)

# a simple normal distribution
dist_norm(p = 0.2)
}

