% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjp.emm.int}
\alias{sjp.emm.int}
\title{Plot adjusted (estimated marginal) means of interaction (moderation) in linear models}
\usage{
sjp.emm.int(fit, swapPredictors = FALSE, plevel = 0.05, title = NULL,
  geom.colors = "Set1", axisTitle.x = NULL, axisTitle.y = NULL,
  legendLabels = NULL, showValueLabels = FALSE, valueLabel.digits = 2,
  breakTitleAt = 50, breakLegendLabelsAt = 20,
  breakAnnotationLabelsAt = 50, axisLimits.y = NULL, gridBreaksAt = NULL,
  printPlot = TRUE)
}
\arguments{
\item{fit}{the fitted linear model (lm) object, including interaction terms}

\item{swapPredictors}{if \code{TRUE}, the grouping variable and predictor on
the x-axis are swapped.}

\item{plevel}{Indicates at which p-value an interaction term is considered as significant. Default is
0.05 (5 percent).}

\item{title}{a default title used for the plots. Default value is \code{NULL}, which means that each plot's title
includes the dependent variable as well as the names of the interaction terms.}

\item{geom.colors}{A vector of color values.}

\item{axisTitle.x}{a default title used for the x-axis. Default value is \code{NULL},
which means that each plot's x-axis uses the predictor's name as title.}

\item{axisTitle.y}{a default title used for the y-axis. Default value is \code{NULL},
which means that each plot's y-axis uses the dependent variable's name as title.}

\item{legendLabels}{Labels for the guide/legend. Default is \code{NULL}, so the name of the predictor with
min/max-effect is used as legend label.}

\item{showValueLabels}{if \code{TRUE}, value labels are plotted along the lines. Default is \code{FALSE}.}

\item{valueLabel.digits}{the amount of digits of the displayed value labels. Defaults to 2.}

\item{breakTitleAt}{Wordwrap for diagram's title. Determines how many chars of the title are
displayed in one line and when a line break is inserted. Default is \code{50}.}

\item{breakLegendLabelsAt}{Wordwrap for diagram legend labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted. Default is \code{20}.}

\item{breakAnnotationLabelsAt}{Wordwrap for diagram annotation labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted. Default is \code{50}.
Only applies if \code{showInterceptLine} is \code{TRUE}.}

\item{axisLimits.y}{A vector with two values, defining the lower and upper limit from the y-axis.
By default, this value is \code{NULL}, i.e. axis limits will be calculated upon the
range of y-values.}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is \code{NULL}.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-objects with the complete plot-list (\code{plot.list})
          as well as the data frame that were used for setting up the ggplot-objects (\code{df.list}).
}
\description{
Plot estimated marginal means of (significant) interaction terms in linear models (lm). This function may
               be used to plot differences in interventions between control and treatment groups over multiple
               time points.
}
\note{
Please note that all interaction terms have to be of type \code{\link{factor}}!
        Furthermore, predictors of interactions that are introduced first into the model
        are used as grouping variable, while the latter predictor is printed along the x-axis
        (i.e. lm(y~a+b+a:b) means that "a" is used as grouping variable and "b" is plotted along the x-axis).
}
\examples{
\dontrun{
# Note that the data sets used in this example may not be perfectly suitable for
# fitting linear models. I just used them because they are part of the R-software.

# prepare data frame
df <- data.frame(mpg=mtcars$mpg,vs=factor(mtcars$vs),am=factor(mtcars$am))
# fit "dummy" model.
fit <- lm(mpg~vs+am+vs:am, data=df)
# show summary to see significant interactions
summary(fit)

# plot marginal means of interaction terms
# note we have to adjust plevel, because no interaction
# is significant
sjp.emm.int(fit, plevel=1)
# plot marginal means of interaction terms, including value labels
sjp.emm.int(fit, plevel=1, showValueLabels=TRUE)


# load sample data set
data(efc)
# create data frame with variables that should be included
# in the model
df <- as.data.frame(cbind(burden=efc$neg_c_7,
                          sex=efc$c161sex,
                          education=efc$c172code))
# convert gender predictor to factor
df$sex <- factor(df$sex)
df$education <- factor(df$education)
# name factor levels and dependent variable
levels(df$sex) <- c("female", "male")
levels(df$education) <- c("low", "mid", "high")
df$burden <- sji.setVariableLabels(df$burden, "care burden")
# fit "dummy" model
fit <- lm(burden ~ .*., data=df, na.action=na.omit)
summary(fit)

# plot marginal means of interactions, no interaction found
sjp.emm.int(fit)
# plot marginal means of interactions, including those with p-value up to 1
sjp.emm.int(fit, plevel=1)
# swap predictors
sjp.emm.int(fit, plevel=1, swapPredictors=TRUE)}
}
\references{
\itemize{
             \item \href{http://www.theanalysisfactor.com/using-adjusted-means-to-interpret-moderators-in-analysis-of-covariance/}{Grace-Martin K: Using Adjusted Means to Interpret Moderators in Analysis of Covariance.}
             }
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.emm.int/}{sjPlot manual: sjp.emm.int}
           \item \href{http://strengejacke.wordpress.com/2014/08/19/visualize-pre-post-comparison-of-intervention-rstats/}{Weblog example}
           \item \code{\link{sjp.lm.int}}
           \item \code{\link{sjp.reglin}}
           \item \code{\link{sjp.aov1}}
           \item \code{\link{sjp.lm.ma}}
         }
}

