% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_sample_functions.R
\name{sits_stratified_sampling}
\alias{sits_stratified_sampling}
\title{Allocation of sample size to strata}
\usage{
sits_stratified_sampling(
  cube,
  sampling_design,
  alloc = "alloc_prop",
  overhead = 1.2,
  multicores = 2L,
  memsize = 2L,
  shp_file = NULL,
  progress = TRUE
)
}
\arguments{
\item{cube}{Classified cube}

\item{sampling_design}{Result of sits_sampling_design}

\item{alloc}{Allocation method chosen}

\item{overhead}{Additional percentage to account
for border points}

\item{multicores}{Number of cores that will be used to
sample the images in parallel.}

\item{memsize}{Memory available for sampling.}

\item{shp_file}{Name of shapefile to be saved (optional)}

\item{progress}{Show progress bar? Default is TRUE.}
}
\value{
samples              Point sf object with required samples
}
\description{
Takes a class cube with different labels and a sampling
design with a number of samples per class and allocates a set of
locations for each class
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # label the probability cube
    label_cube <- sits_label_classification(
        probs_cube,
        output_dir = tempdir()
    )
    # estimated UA for classes
    expected_ua <- c(
        Cerrado = 0.95, Forest = 0.95,
        Pasture = 0.95, Soy_Corn = 0.95
    )
    # design sampling
    sampling_design <- sits_sampling_design(label_cube, expected_ua)
    # select samples
    samples <- sits_stratified_sampling(
        label_cube,
        sampling_design, "alloc_prop"
    )
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Felipe Carlos, \email{efelipecarlos@gmail.com}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
