% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_filters.R
\name{sits_whittaker}
\alias{sits_whittaker}
\title{Filter time series with whittaker filter}
\usage{
sits_whittaker(data = NULL, lambda = 0.5)
}
\arguments{
\item{data}{Time series or matrix.}

\item{lambda}{Smoothing factor to be applied (default 0.5).}
}
\value{
Filtered time series
}
\description{
The algorithm searches for an optimal warping polynomial.
The degree of smoothing depends on smoothing factor lambda
(usually from 0.5 to 10.0). Use lambda = 0.5 for very slight smoothing
and lambda = 5.0 for strong smoothing.
}
\examples{
if (sits_run_examples()) {
    # Retrieve a time series with values of NDVI
    point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")
    # Filter the point using the Whittaker smoother
    point_whit <- sits_filter(point_ndvi, sits_whittaker(lambda = 3.0))
    # Merge time series
    point_ndvi <- sits_merge(point_ndvi, point_whit,
                            suffix = c("", ".WHIT"))
    # Plot the two points to see the smoothing effect
    plot(point_ndvi)
}
}
\references{
Francesco Vuolo, Wai-Tim Ng, Clement Atzberger,
"Smoothing and gap-filling of high resolution multi-spectral time series:
Example of Landsat data",
Int Journal of Applied Earth Observation and Geoinformation,
vol. 57, pg. 202-213, 2107.
}
\seealso{
\link[sits]{sits_apply}
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
