% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timegap.R
\name{timegap}
\alias{timegap}
\alias{timegap.id}
\alias{diffid}
\title{Select equally spaced ages from a vector of ages}
\usage{
timegap(age, gap, tol = 0.1 * gap, multiple = FALSE)

timegap.id(age, id, data = parent.frame(), gap, tol = 0.1 * gap,
  multiple = FALSE)

diffid(age, id, data = parent.frame(), lag = 1, differences = 1,
  sort = FALSE, keepNA = FALSE)
}
\arguments{
\item{age}{vector of ages.}

\item{gap}{numeric, the required positive time gap between selected ages.}

\item{tol}{numeric, the positive tolerance around the gap (default \code{0.1 * gap}).}

\item{multiple}{logical, whether or not to return multiple solutions
when found (default FALSE).}

\item{id}{factor of subject ids.}

\item{data}{data frame optionally containing \code{age} and \code{id}.}

\item{lag}{an integer indicating which lag to use.}

\item{differences}{an integer indicating the order of the difference.}

\item{sort}{a logical indicating whether to first sort by id and age.}

\item{keepNA}{a logical indicating whether to keep generated NAs.}
}
\value{
With \code{timegap}, for unique solutions, or multiple solutions with
\code{multiple FALSE}, a vector of indices named with \code{age}. With
\code{timegap.id} the subject vectors are returned invisibly, concatenated.

With \code{multiple TRUE}, where there are multiple solutions
they are returned as a named matrix.

\code{diffid} returns \code{diff(age)} applied within \code{id}.
With \code{keepNA} TRUE a suitable number of \code{NA}s are added at the end,
while if FALSE all \code{NA}s are omitted.
}
\description{
\code{timegap} indexes elements in a vector of ages such that the indexed
ages are spaced integer multiples of a time interval apart, to within a given
tolerance. \code{timegap.id} is a wrapper to apply \code{timegap} within levels
of factor \code{id}. The selected ages can then be split into age groups the
specified time interval wide, ensuring that (virtually) every subject
has at most one measurement per interval.
}
\details{
\code{timegap} calculates all possible differences between pairs of ages,
expresses them as integer multiples of \code{gap}, restricts them to
those within tolerance and identifies those providing the longest sequences.
For sequences of the same length, those with the smallest standard deviation
of successive differences (modulo the time interval) are selected.
}
\examples{
data(heights)

## bin age into 1-year groups by id
## gives multiple measurements per id per year
with(heights, table(floor(age), id))

## now select heights measured multiples of 1 year apart
(tg1 <- timegap.id(age, id, heights, 1))

## no more than one measurement per id per year
with(heights[tg1, ], table(floor(age), id))

## most time intervals close to 1 year
summary(diffid(age, id, heights[tg1, ], lag=1))
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
