% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{mergeComplexesAbundance}
\alias{mergeComplexesAbundance}
\title{Merge the free and in-complex versions of molecules.}
\usage{
mergeComplexesAbundance(df)
}
\arguments{
\item{df}{A dataframe with the abundance of the different molecules over time (from \code{\link{simulateInSilicoSystem}}
or \code{\link{simulateParallelInSilicoSystem}}).}
}
\value{
A dataframe in which the abundance of free and in complex versions of a molecule have been merged to give the abundance of the molecule (without distinction of whether or not it is bound in a molecular complex).
}
\description{
Merge (i.e. sum) the abundance of the free and in-complex versions of each molecule in the results of a simulation.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 5, PC.p = 1, PC.TC.p = 1, ploidy = 1)
mysystem = addComplex(mysystem, c(1, 2))
mypop = createInSilicoPopulation(1, mysystem)
sim = simulateInSilicoSystem(mysystem, mypop, 100)
head(sim$Simulation)
mergedComplex = mergeComplexesAbundance(sim$Simulation)
head(mergedComplex)
}
}
