% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{carcassubmission}
\alias{carcassubmission}
\title{British farm carcass submissions data}
\format{
Data frame with 1,858 rows and 4 columns.
\describe{
\item{\code{TOTAL_SUB}}{Number of submissions of animal carcasses.}
\item{\code{log_size}}{Numerical value equal to logarithm of size of farm.}
\item{\code{log_distance}}{Numerical value equal to logarithm of distance to nearest AHVLA center.}
\item{\code{C_TYPE}}{Factor describing type of activity on farm that animals are
used for. Either \code{Dairy} or \code{Beef}}
}
}
\usage{
data("carcassubmission")
}
\description{
Data on British animal farms submissions to AHVLA. British farms
are able to submit samples to AHVLA if cause of death for an animal
cannot be determined and private veterinary surgeon decides to submit them,
unless there is notifiable disease suspected then such a submission is not
required.

This data set contains information about such farms.
Only submissions that are included in this data frame
are submissions of carcasses i.e. submissions of blood samples etc.
are excluded.
}
\references{
This data set and its description was provided in publication:
Böhning, D., Vidal Diez, A., Lerdsuwansri, R., Viwatwongkasem, C., and Arnold, M. (2013). "A generalization of Chao's estimator for covariate information". \emph{Biometrics}, 69(4), 1033-1042. doi:10.1111/biom.12082
}
\keyword{datasets}
