% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-to-simulation.R
\docType{methods}
\name{add}
\alias{add}
\alias{add,Simulation,DrawsRef-method}
\alias{add,Simulation,EvalsRef-method}
\alias{add,Simulation,ModelRef-method}
\alias{add,Simulation,OutputRef-method}
\alias{add,Simulation,list-method}
\title{Add a reference to a simulation}
\usage{
add(sim, ref, ...)

\S4method{add}{Simulation,ModelRef}(sim, ref, update_saved = TRUE)

\S4method{add}{Simulation,DrawsRef}(sim, ref, update_saved = TRUE)

\S4method{add}{Simulation,OutputRef}(sim, ref, update_saved = TRUE)

\S4method{add}{Simulation,EvalsRef}(sim, ref, update_saved = TRUE)

\S4method{add}{Simulation,list}(sim, ref, update_saved = TRUE)
}
\arguments{
\item{sim}{simulation being added to}

\item{ref}{the reference object being added}

\item{...}{not used}

\item{update_saved}{default is TRUE. Determines whether change to simulation
object should be saved to file}
}
\description{
Adds a ModelRef, DrawsRef, OutputRef, or EvalsRef to a simulation object.
To add a DrawsRef, the corresponding ModelRef must already be added.
Likewise, to add an OutputRef, the corresponding DrawsRef must already be
added.  And to add an EvalsRef, the corresponding OutputRef must be added.
One can also pass a list of such objects.
}
\details{
The modified simulation object is saved to file if \code{update_saved} is
TRUE.
}

