% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{SARMA}
\alias{SARMA}
\title{Create a Seasonal Autoregressive Moving Average (SARMA) Process}
\usage{
SARMA(ar = 1, ma = 1, sar = 1, sma = 1, s = 12, sigma2 = 1)
}
\arguments{
\item{ar}{A \code{vector} or \code{integer} containing either the coefficients for \eqn{\phi}{phi}'s or the process number \eqn{p} for the Autoregressive (AR) term.}

\item{ma}{A \code{vector} or \code{integer} containing either the coefficients for \eqn{\theta}{theta}'s or the process number \eqn{q} for the Moving Average (MA) term.}

\item{sar}{A \code{vector} or \code{integer} containing either the coefficients for \eqn{\Phi}{PHI}'s or the process number \eqn{P} for the Seasonal Autoregressive (SAR) term.}

\item{sma}{A \code{vector} or \code{integer} containing either the coefficients for \eqn{\Theta}{THETA}'s or the process number \eqn{Q} for the Seasonal Moving Average (SMA) term.}

\item{s}{A \code{integer} indicating the seasonal value of the data.}

\item{sigma2}{A \code{double} value for the standard deviation, \eqn{\sigma}{sigma}, of the SARMA process.}
}
\value{
An S3 object with called ts.model with the following structure:
\describe{
 \item{process.desc}{\eqn{AR*p}{AR x p}, \eqn{MA*q}{MA x q}, \eqn{SAR*P}{SAR x P}, \eqn{SMA*Q}{SMA x Q}}
 \item{theta}{\eqn{\sigma}{sigma}}
 \item{plength}{Number of Parameters}
 \item{print}{String containing simplified model}
 \item{obj.desc}{y desc replicated x times}
 \item{obj}{Depth of Parameters e.g. list(c(length(ar), length(ma), length(sar), length(sma), 1) )}
 \item{starting}{Guess Starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Sets up the necessary backend for the SARMA process.
}
\details{
A variance is required since the model generation statements utilize 
randomization functions expecting a variance instead of a standard deviation unlike R.
}
\examples{
# Create an SARMA(1,2)x(1,1) process
SARMA(ar = 1, ma = 2,sar = 1, sma =1)

# Creates an SARMA(1,1)x(1,1) process with predefined coefficients.
SARMA(ar=0.23, ma=0.4, sar = .3, sma = .3)
}
\author{
James Balamuta
}
