% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACF.R
\name{plot.simtsACF}
\alias{plot.simtsACF}
\title{Plot Auto-Covariance and Correlation Functions}
\usage{
\method{plot}{simtsACF}(x, xlab = NULL, ylab = NULL, show.ci = TRUE,
  alpha = NULL, col_ci = NULL, transparency = NULL, main = NULL,
  parValue = NULL, ...)
}
\arguments{
\item{x}{An \code{"ACF"} object output from \code{theo_acf} and \code{auto_corr}.}

\item{xlab}{A \code{string} indicating the label of the x axis: the default name is 'Lags'.}

\item{ylab}{A \code{string} indicating the label of the y axis: the default name is 'ACF'.}

\item{show.ci}{A \code{bool} indicating whether to show the confidence region. Defaults to \code{TRUE}.}

\item{alpha}{A \code{double} indicating the level of significance for the confidence interval. By default \code{alpha = 0.05} which gives a 1 - \code{alpha} = 0.95 confidence interval.}

\item{col_ci}{A \code{string} that specifies the color of the region covered by the confidence intervals (confidence region).}

\item{transparency}{A \code{double} between 0 and 1 indicating the transparency level of the color defined in \code{col_ci}.
Defaults to 0.25.}

\item{main}{A \code{string} indicating the title of the plot. Default name is "Variable name ACF plot'.}

\item{parValue}{A \code{vector} defining the margins for the plot.}

\item{...}{Additional parameters}
}
\description{
The function plots the output of the \code{theo_acf} and \code{auto_corr} functions (autocovariance or autocorrelation functions).
}
\examples{
# Calculate the Autocorrelation
m = auto_corr(datasets::AirPassengers)

# Plot with 95\% CI
plot(m) 

# Plot with 90\% CI
plot(m, alpha = 0.1) 

# Plot without 95\% CI
plot(m, show.ci = FALSE)

# More customized CI
plot(m, xlab = "my xlab", ylab = "my ylab", show.ci = TRUE,
alpha = NULL, col_ci = "grey", transparency = 0.5, main = "my main")
}
\author{
Yunxiang Zhang, Stéphane Guerrier and Yuming Zhang
}
