% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_trait.R
\name{cov_trait}
\alias{cov_trait}
\title{The model covariance matrix of the trait}
\usage{
cov_trait(kinship, herit, sigma_sq = 1)
}
\arguments{
\item{kinship}{The \code{n}-by-\code{n} kinship matrix of the individuals.
These values should be scaled such that an outbred individual has 1/2 self-kinship, the parent-child relationship is 1/4, etc (which is half the values sometimes defined for kinship).}

\item{herit}{The heritability (proportion of trait variance due to genetics).}

\item{sigma_sq}{Overall variance multiplicative factor (default 1).
This factor corresponds to the variance of an outbred individual.}
}
\value{
The \code{n}-by-\code{n} trait covariance matrix equal to
\code{sigma_sq * ( herit * 2 * kinship + ( 1 - herit ) * I )},
where \code{I} is the \code{n}-by-\code{n} identity matrix.
}
\description{
This function returns the expected covariance matrix of a trait vector simulated via \code{sim_trait}.
Below there are \code{n} individuals.
}
\examples{
# create a dummy kinship matrix
kinship <- matrix(
    data = c(
        0.6, 0.1, 0.0,
        0.1, 0.6, 0.1,
        0.0, 0.1, 0.6
    ),
    nrow = 3,
    byrow = TRUE
)
# covariance of simulated traits
V <- cov_trait(kinship = kinship, herit = 0.8)

}
