% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trtObserve.R
\name{trtObserve}
\alias{trtObserve}
\title{Observed exposure or treatment}
\usage{
trtObserve(dt, formulas, logit.link = FALSE, grpName = "trtGrp")
}
\arguments{
\item{dt}{data table}

\item{formulas}{collection of formulas that determine probabilities}

\item{logit.link}{indicator that specifies link. If TRUE, then logit link
is used. If FALSE, the identity link is used.}

\item{grpName}{character string representing name of treatment/exposure group
variable}
}
\value{
An integer (group) ranging from 1 to length of the probability vector
}
\description{
Observed exposure or treatment
}
\examples{
def <- defData(varname = "male", dist = "binary", formula = .5 , id="cid")
def <- defData(def, varname = "over65", dist = "binary", formula = "-1.7 + .8*male", link="logit")
def <- defData(def, varname = "baseDBP", dist = "normal", formula = 70, variance = 40)

dtstudy <- genData(1000, def)
dtstudy

formula1 <- c("-2 + 2*male - .5*over65", "-1 + 2*male + .5*over65")
dtObs <- trtObserve(dtstudy, formulas = formula1, logit.link = TRUE, grpName = "exposure")
dtObs

# Check actual distributions

dtObs[, .(pctMale = round(mean(male),2)), keyby = exposure]
dtObs[, .(pctMale = round(mean(over65),2)), keyby = exposure]

dtSum <- dtObs[, .N, keyby = .(male, over65, exposure)]
dtSum[, grpPct :=round(N/sum(N), 2), keyby = .(male, over65)]
dtSum
}
\seealso{
\code{\link{trtAssign}}
}

