% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_density.R
\name{gg_density}
\alias{gg_density}
\title{DEPRECATED. Density ggplot.}
\usage{
gg_density(
  data,
  x_var,
  pal = pal_viridis_mix(1),
  alpha_fill = 0.5,
  alpha_line = 1,
  size_line = 0.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_zero_mid = FALSE,
  x_breaks_n = 5,
  x_expand = c(0, 0),
  x_labels = scales::label_comma(),
  x_title = NULL,
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_breaks_n = 5,
  y_expand = c(0, 0),
  y_labels = scales::label_comma(),
  y_title = NULL,
  y_title_wrap = 50,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(y_grid = TRUE),
  model_bw = "nrd0",
  model_adjust = 1,
  model_kernel = "gaussian",
  model_n = 512,
  model_trim = FALSE,
  mobile = FALSE
)
}
\arguments{
\item{data}{A data frame in a structure to be transformed to density statistics. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{pal}{Character vector of hex codes.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.5.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{size_line}{The size of the outlines of density areas.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 75.}

\item{x_zero_mid}{For a numeric x variable, add balance to the x scale so that zero is in the centre. Defaults to FALSE.}

\item{x_breaks_n}{For a numeric x variable, the desired number of intervals on the x scale, as calculated by the}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE of whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_breaks_n}{For a numeric y variable, the desired number of intervals on the y scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels.  Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{model_bw}{The bw argument of the stats::density function. Defaults to "nrd0".}

\item{model_adjust}{The adjust argument of the stats::density function. Defaults to 1.}

\item{model_kernel}{The kernel argument of the stats::density function. Defaults to "gaussian".}

\item{model_n}{The n argument of the stats::density function. Defaults to 512.}

\item{model_trim}{TRUE or FALSE of whether to trim the tails. Defaults to FALSE.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
DEPRECATED. Density ggplot that is not coloured and not facetted.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_density(penguins, 
           x_var = body_mass_g)

}
