% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sf_fun.R
\name{ggplot_sf_facet}
\alias{ggplot_sf_facet}
\title{Map of simple features in ggplot that is facetted.}
\usage{
ggplot_sf_facet(data, facet_var, size = 0.5, alpha = 0.1, pal = NULL,
  facet_nrow = NULL, boundary = NULL, boundary_behind = TRUE,
  boundary_pal = "#7f7f7f", boundary_size = 0.2, title = "[Title]",
  subtitle = NULL, caption = NULL, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL, title_wrap = 70,
  subtitle_wrap = 80, caption_wrap = 80)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{size}{Size of features (or shape outlines if polygon). Defaults to 0.5.}

\item{alpha}{The alpha of the fill. Defaults to 0.1. Only applicable to polygons.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects a default palette.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{boundary}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added.}

\item{boundary_behind}{TRUE or FALSE  as to whether the boundary is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{boundary_pal}{Colour of the boundary. Defaults to "#7F7F7F".}

\item{boundary_size}{Size of the boundary. Defaults to 0.2.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is facetted, but not coloured.
}
\examples{
ggplot_sf_facet(data = example_sf_point, facet_var = trend_category, 
  boundary = nz,
  title = "Trends, 1990-2017")
}
